/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.security.defaults;

import java.util.List;
import org.gcube.common.security.credentials.Credentials;
import org.gcube.common.security.factories.AuthorizationProviderFactory;
import org.gcube.common.validator.ValidatorFactory;
import org.gcube.common.validator.annotations.NotEmpty;
import org.gcube.smartgears.security.SimpleCredentials;
import org.gcube.smartgears.security.defaults.DefaultAuthorizationProvider;

public class DefaultAuthorizationProviderFactory
implements AuthorizationProviderFactory<DefaultAuthorizationProvider> {
    @NotEmpty
    private String endpoint;

    public DefaultAuthorizationProvider connect(Credentials credentials) {
        if (!SimpleCredentials.class.isInstance(credentials)) {
            throw new IllegalArgumentException("invalid credential type passed");
        }
        List errors = ValidatorFactory.validator().validate((Object)credentials);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(String.format("invalid credential: %s", errors));
        }
        if (this.endpoint == null || this.endpoint.isEmpty()) {
            throw new IllegalArgumentException("invalid enpoint passed");
        }
        return new DefaultAuthorizationProvider((SimpleCredentials)credentials, this.endpoint);
    }

    public String toString() {
        return "DefaultAuthorizationProviderFactory [endpoint=" + this.endpoint + "]";
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

