/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Objects;
import org.gcube.io.jsonwebtoken.lang.Supplier;

public class RedactedSupplier<T>
implements Supplier<T> {
    public static final String REDACTED_VALUE = "<redacted>";
    private final T value;

    public RedactedSupplier(T value) {
        this.value = Assert.notNull(value, (String)"value cannot be null.");
    }

    public T get() {
        return this.value;
    }

    public int hashCode() {
        return Objects.nullSafeHashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RedactedSupplier) {
            obj = ((RedactedSupplier)obj).value;
        }
        return Objects.nullSafeEquals(this.value, (Object)obj);
    }

    public String toString() {
        return REDACTED_VALUE;
    }
}

