/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.binder.tomcat.TomcatMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Collections;
import java.util.Set;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.managers.ApplicationManager;
import org.gcube.smartgears.managers.ContainerManager;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap
implements ServletContainerInitializer {
    private static Logger log = LoggerFactory.getLogger(Bootstrap.class);
    private static boolean smartgearsHasStarted = false;
    private static boolean containerHasFailed = false;
    private static ContainerManager manager;
    private static ContainerContext context;

    public Bootstrap() {
        log.info("bootstrap started the container");
        if (smartgearsHasStarted) {
            return;
        }
        smartgearsHasStarted = true;
        this.initialiseContainer();
        this.startContainerIfItHasntAlreadyFailed();
    }

    public void onStartup(Set<Class<?>> c, ServletContext application) throws ServletException {
        ApplicationManager appManager = new ApplicationManager();
        log.info("check if is managed @ {}", (Object)application.getContextPath());
        if (this.isResource(application)) {
            try {
                log.info("starting management of application @ {}", (Object)application.getContextPath());
                ApplicationContext app = appManager.start(context, application);
                manager.manage(app);
                context.configuration().app(app.configuration());
            }
            catch (Throwable t) {
                appManager.stop();
                throw new ServletException("cannot manage application @ " + application.getContextPath() + " (see cause)", t);
            }
        } else {
            log.info("is not managed @ {}", (Object)application.getContextPath());
        }
    }

    private void initialiseContainer() {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ContainerManager.class.getClassLoader());
            log.trace("smartgears is starting");
            context = ProviderFactory.provider().containerContext();
            PrometheusMeterRegistry registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            new ClassLoaderMetrics().bindTo((MeterRegistry)registry);
            new JvmMemoryMetrics().bindTo((MeterRegistry)registry);
            new JvmGcMetrics().bindTo((MeterRegistry)registry);
            new ProcessorMetrics().bindTo((MeterRegistry)registry);
            new JvmThreadMetrics().bindTo((MeterRegistry)registry);
            new UptimeMetrics().bindTo((MeterRegistry)registry);
            new ProcessorMetrics().bindTo((MeterRegistry)registry);
            new TomcatMetrics(null, Collections.emptyList()).bindTo((MeterRegistry)registry);
            new LogbackMetrics().bindTo((MeterRegistry)registry);
            new JvmInfoMetrics().bindTo((MeterRegistry)registry);
            Metrics.addRegistry((MeterRegistry)registry);
            context.configuration().validate();
        }
        catch (RuntimeException e) {
            containerHasFailed = true;
            log.error("cannot start smartgears", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    private void startContainerIfItHasntAlreadyFailed() {
        if (containerHasFailed) {
            throw new IllegalStateException("container is not managed due to previous failure");
        }
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ContainerManager.class.getClassLoader());
            manager = ContainerManager.instance;
            context = manager.start(context);
        }
        catch (RuntimeException e) {
            containerHasFailed = true;
            throw new IllegalStateException("cannot manage container", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    private boolean isResource(ServletContext application) {
        return !containerHasFailed && context.configuration().app(application.getContextPath()) != null || application.getResourceAsStream("/WEB-INF/application.yaml") != null;
    }
}

