/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.discovery.client.queries.impl;

import java.net.URI;
import java.util.Map;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.QueryTemplate;

public class XQuery
extends QueryTemplate
implements SimpleQuery {
    public static final String ns = "ns";
    public static final String vars = "vars";
    public static final String range = "range";
    public static final String cond = "cond";
    public static final String result = "result";
    public static final String template = "<ns/> for $resource in <range/><vars/> where <cond def='$resource'/> return <result def='$resource'/>";

    public XQuery(Map<String, String> parameters) {
        super(template, parameters);
    }

    @Override
    public XQuery addCondition(String condition) {
        String newcond = "(" + condition + ")";
        if (this.hasParameter(cond)) {
            this.appendParameter(cond, " and " + newcond);
        } else {
            this.addParameter(cond, newcond);
        }
        return this;
    }

    @Override
    public XQuery addNamespace(String prefix, URI uri) {
        String declaration = "declare namespace " + prefix + " = '" + String.valueOf(uri) + "';";
        this.appendParameter(ns, declaration);
        return this;
    }

    @Override
    public XQuery addVariable(String variable, String range) {
        String declaration = ", " + variable + " in " + range;
        this.appendParameter(vars, declaration);
        return this;
    }

    @Override
    public XQuery setResult(String expression) {
        this.addParameter(result, expression);
        return this;
    }
}

