/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.model.impl.relations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.impl.relations.RelationElementImpl;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.serialization.ElementMapper;

@JsonTypeName(value="Relation")
public abstract class RelationImpl<S extends Resource, T extends Entity>
extends RelationElementImpl<S, T>
implements Relation<S, T> {
    private static final long serialVersionUID = -6249979476879235053L;
    protected List<String> supertypes;
    protected String expectedtype;
    protected Map<UUID, String> contexts;
    protected PropagationConstraint propagationConstraint;
    @JsonIgnore
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final Set<String> allowedAdditionalKeys = new HashSet<String>();

    protected RelationImpl() {
    }

    protected RelationImpl(S source, T target, PropagationConstraint propagationConstraint) {
        this();
        this.source = source;
        this.target = target;
        this.propagationConstraint = propagationConstraint;
    }

    @Override
    public List<String> getSupertypes() {
        return this.supertypes;
    }

    @Override
    public String getExpectedtype() {
        return this.expectedtype;
    }

    @Override
    public Map<UUID, String> getContexts() {
        return this.contexts;
    }

    @JsonSetter(value="contexts")
    protected void setContexts(Map<UUID, String> contexts) {
        this.contexts = contexts;
    }

    @Override
    public PropagationConstraint getPropagationConstraint() {
        return this.propagationConstraint;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Override
    public Object getAdditionalProperty(String key) {
        return this.additionalProperties.get(key);
    }

    @Override
    public void setAdditionalProperty(String key, Object value) {
        if (!this.allowedAdditionalKeys.contains(key)) {
            if (key.startsWith("_")) {
                return;
            }
            if (key.startsWith("@")) {
                return;
            }
            if (key.compareTo("propagationConstraint") == 0) {
                return;
            }
            if (key.compareTo("target") == 0) {
                return;
            }
            if (key.compareTo("source") == 0) {
                return;
            }
        }
        try {
            Map map;
            if (value instanceof Map && (map = (Map)value).containsKey("type")) {
                String reserialized = ElementMapper.getObjectMapper().writeValueAsString((Object)map);
                Property property = ElementMapper.unmarshal(Property.class, reserialized);
                value = property;
            }
        }
        catch (Throwable e) {
            e.getMessage();
        }
        this.additionalProperties.put(key, value);
    }
}

