/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.publisher.is.legacy;

import java.net.URI;
import java.util.List;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.common.core.publisher.is.legacy.RegistryCache;
import org.gcube.common.core.publisher.is.legacy.RegistryNotFoundException;
import org.gcube.common.core.publisher.is.legacy.stubs.RegistryConstants;
import org.gcube.common.core.publisher.is.legacy.stubs.RegistryStub;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.api.ResultParser;
import org.gcube.resources.discovery.client.impl.DelegateClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICClient;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registry {
    private RegistryCache cache = new RegistryCache(10);
    private List<URI> endpoints;
    private static final Logger log = LoggerFactory.getLogger(Registry.class);

    public List<URI> getEndPoints() {
        String scope = SecretManagerProvider.get().getContext();
        this.endpoints = this.cache.get(scope);
        if (this.endpoints == null) {
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            ResultParser<URI> uriParser = new ResultParser<URI>(){

                public URI parse(String result) throws Exception {
                    return new URI(result.replaceAll("\n", ""));
                }
            };
            DelegateClient client = new DelegateClient((ResultParser)uriParser, (DiscoveryClient)new ICClient());
            query.addCondition("$resource/Profile/ServiceClass/text() eq '" + RegistryConstants.service_class + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + RegistryConstants.service_name + "'").setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint[string(@EntryName) eq '" + RegistryConstants.service_entrypoint + "']/string()");
            this.endpoints = client.submit((Query)query);
            if (this.endpoints.size() == 0) {
                throw new IllegalArgumentException("No endpoint for registry found");
            }
            this.cache.put(scope, this.endpoints);
        }
        return this.endpoints;
    }

    public RegistryStub getStubs() throws RegistryNotFoundException {
        String context = SecretManagerProvider.get().getContext();
        URI endpoint = null;
        endpoint = this.getEndPoints().get(0);
        log.debug("get stubs in context {} from endpoint {} ", (Object)context, (Object)endpoint);
        return (RegistryStub)StubFactory.stubFor(RegistryConstants.registry).at(endpoint);
    }

    public RegistryStub getStubs(URI endpoint) throws RegistryNotFoundException {
        String context = SecretManagerProvider.get().getContext();
        log.debug("get stubs in context {} from fixed endpoint {} ", (Object)context, (Object)endpoint);
        return (RegistryStub)StubFactory.stubFor(RegistryConstants.registry).at(endpoint);
    }
}

