/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.extensions.resource;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.health.api.HealthCheck;
import org.gcube.common.health.api.ReadinessChecker;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.extensions.ApiResource;
import org.gcube.smartgears.extensions.ApiSignature;
import org.gcube.smartgears.extensions.HttpExtension;
import org.gcube.smartgears.health.HealthManager;
import org.gcube.smartgears.health.HealthResponse;
import org.gcube.smartgears.health.HealthTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthResource
extends ApiResource {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(HealthResource.class);
    public static final String mapping = "/health";
    private static final ApiSignature signature = HealthResource.handles("/health").with(HealthResource.method(HttpExtension.Method.GET).produces("application/json"));
    private HealthManager manager;
    private HealthTask task;
    private Timer timer;

    HealthResource() {
        super(signature);
    }

    @Override
    public void init(ApplicationContext context) throws Exception {
        Set annotatedReadiness;
        try (ScanResult result = new ClassGraph().enableClassInfo().enableAnnotationInfo().scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(ReadinessChecker.class.getName());
            annotatedReadiness = classInfos.stream().map(ClassInfo::loadClass).filter(c -> HealthCheck.class.isAssignableFrom((Class<?>)c)).collect(Collectors.toSet());
        }
        this.manager = new HealthManager();
        for (Class readnessClass : annotatedReadiness) {
            try {
                this.manager.register((HealthCheck)readnessClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                log.info("added class {} to health manager", (Object)readnessClass.getCanonicalName());
            }
            catch (Throwable e) {
                log.error("healthChecker class {} cannot be instantiated", (Object)readnessClass.getCanonicalName(), (Object)e);
            }
        }
        this.task = new HealthTask(this.manager);
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)this.task, 10000L, 60000L);
        super.init(context);
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter out = resp.getWriter();
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        HealthResponse response = this.readiness();
        new ObjectMapper().writeValue((Writer)out, (Object)response);
        out.flush();
    }

    public HealthResponse readiness() {
        return this.task.getResponse();
    }
}

