/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import org.gcube.io.jsonwebtoken.impl.lang.Bytes;
import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.lang.Assert;

public class RequiredBitLengthConverter
implements Converter<byte[], Object> {
    private final Converter<byte[], Object> converter;
    private final int bitLength;
    private final boolean exact;

    public RequiredBitLengthConverter(Converter<byte[], Object> converter, int bitLength) {
        this(converter, bitLength, true);
    }

    public RequiredBitLengthConverter(Converter<byte[], Object> converter, int bitLength, boolean exact) {
        this.converter = (Converter)Assert.notNull(converter, (String)"Converter cannot be null.");
        this.bitLength = (Integer)Assert.gt((Comparable)Integer.valueOf(bitLength), (Comparable)Integer.valueOf(0), (String)"bitLength must be greater than 0");
        this.exact = exact;
    }

    private byte[] assertLength(byte[] bytes) {
        long len = Bytes.bitLength(bytes);
        if (this.exact && len != (long)this.bitLength) {
            String msg = "Byte array must be exactly " + Bytes.bitsMsg(this.bitLength) + ". Found " + Bytes.bitsMsg(len);
            throw new IllegalArgumentException(msg);
        }
        if (len < (long)this.bitLength) {
            String msg = "Byte array must be at least " + Bytes.bitsMsg(this.bitLength) + ". Found " + Bytes.bitsMsg(len);
            throw new IllegalArgumentException(msg);
        }
        return bytes;
    }

    @Override
    public Object applyTo(byte[] bytes) {
        this.assertLength(bytes);
        return this.converter.applyTo(bytes);
    }

    @Override
    public byte[] applyFrom(Object o) {
        byte[] result = this.converter.applyFrom(o);
        return this.assertLength(result);
    }
}

