/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl;

import java.security.MessageDigest;
import org.gcube.io.jsonwebtoken.ProtectedHeader;
import org.gcube.io.jsonwebtoken.ProtectedJwt;
import org.gcube.io.jsonwebtoken.impl.DefaultJwt;
import org.gcube.io.jsonwebtoken.io.Encoders;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Objects;

abstract class DefaultProtectedJwt<H extends ProtectedHeader, P>
extends DefaultJwt<H, P>
implements ProtectedJwt<H, P> {
    protected final byte[] digest;
    private final String digestName;

    protected DefaultProtectedJwt(H header, P payload, byte[] digest, String digestName) {
        super(header, payload);
        this.digest = Assert.notEmpty((byte[])digest, (String)"Digest byte array cannot be null or empty.");
        this.digestName = (String)Assert.hasText((CharSequence)digestName, (String)"digestName cannot be null or empty.");
    }

    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    protected StringBuilder toStringBuilder() {
        String b64Url = (String)Encoders.BASE64URL.encode((Object)this.digest);
        return super.toStringBuilder().append(',').append(this.digestName).append('=').append(b64Url);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultProtectedJwt) {
            DefaultProtectedJwt pjwt = (DefaultProtectedJwt)obj;
            return super.equals(pjwt) && MessageDigest.isEqual(this.digest, pjwt.digest);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.nullSafeHashCode((Object[])new Object[]{this.getHeader(), this.getPayload(), this.digest});
    }
}

