package org.gcube.vomanagement.occi.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;

public class X509CredentialManager {
	
	public static final String OUTPUT_PATH = "/tmp/";

	public static String createProxy(String path, String pwd) {
		Random random = new Random();
		int number = random.nextInt();
		number = number >= 0 ? number : -number;
		String outputCert = OUTPUT_PATH + "proxy" + number + ".pem";

		try {

			StringBuilder vomsCommand = new StringBuilder();

			vomsCommand
					.append("echo ")
					.append(pwd)
					.append(" | voms-proxy-init --voms fedcloud.egi.eu --rfc --dont-verify-ac --rfc -cert ");
			vomsCommand.append(path).append(" -out ").append(outputCert)
					.append(" -pwstdin");
			String[] command = { "/bin/sh", "-c", vomsCommand.toString() };
			System.out.println(command[2]);

			ProcessBuilder pb = new ProcessBuilder(command);
			pb.redirectErrorStream(true);
			Process proc = pb.start();
			System.out.println("Process started !");
			String line;
			BufferedReader in = new BufferedReader(new InputStreamReader(
					proc.getInputStream()));
			while ((line = in.readLine()) != null) {
				System.out.println(line);
			}
			proc.destroy();
			System.out.println("Process ended !");
			System.out.println("Proxy Certificate created");

		} catch (IOException ex) {
			throw new RuntimeException(ex);
		}
		return outputCert;
	}

}
