/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl;

import java.util.Map;
import org.apache.axis.MessageContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.impl.GCUBEAuthzChainAuthorizationController;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.impl.EqualDNAuthorizationController;

public class DNSelectionAuthorizationController
implements GCUBEServiceAuthorizationController {
    private GCUBEServiceSecurityManager securityManager;
    private GCUBELog logger = new GCUBELog((Object)this);
    private EqualDNAuthorizationController equalDnController;
    private GCUBEAuthzChainAuthorizationController chainController;

    public void initialise(GCUBEServiceContext ctxt, GCUBEServiceSecurityManager securityManager) throws Exception {
        this.securityManager = securityManager;
        this.equalDnController = new EqualDNAuthorizationController();
        this.equalDnController.initialise(ctxt, securityManager);
        this.chainController = new GCUBEAuthzChainAuthorizationController();
        this.chainController.initialise(ctxt, securityManager);
    }

    public boolean isSecurityEnabled() {
        return this.securityManager.isSecurityEnabled();
    }

    public void authoriseCall(Map<String, Object> parameters) throws GCUBEException {
        this.logger.debug((Object)"External request authorization process");
        if (this.isSecurityEnabled()) {
            MessageContext messageContext = (MessageContext)parameters.get("MESSAGE_CONTEXT");
            if (messageContext == null) {
                this.logger.error((Object)"Unable to find message context");
                throw new GCUBEUnrecoverableException("Unable to find message context");
            }
            try {
                this.equalDnController.authoriseCall(parameters);
            }
            catch (GCUBEException e1) {
                this.logger.debug((Object)"Caller DN not equal to host DN, trying the chain based authz");
                this.chainController.authoriseCall(parameters);
            }
        } else {
            this.logger.debug((Object)"Security not enabled, nothing to do");
        }
    }
}

