/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl;

import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.ietf.jgss.GSSException;

public class EqualDNAuthorizationController
implements GCUBEServiceAuthorizationController {
    private GCUBEServiceSecurityManager securityManager;
    private GCUBELog logger = new GCUBELog((Object)this);

    public void initialise(GCUBEServiceContext ctxt, GCUBEServiceSecurityManager securityManager) throws Exception {
        this.securityManager = securityManager;
    }

    public boolean isSecurityEnabled() {
        return this.securityManager.isSecurityEnabled();
    }

    public void authoriseCall(Map<String, Object> parameters) throws GCUBEException {
        this.logger.debug((Object)"External request authorization process");
        if (this.isSecurityEnabled()) {
            MessageContext messageContext = (MessageContext)parameters.get("MESSAGE_CONTEXT");
            if (messageContext == null) {
                this.logger.error((Object)"Unable to find message context");
                throw new GCUBEUnrecoverableException("Unable to find message context");
            }
            Subject subject = (Subject)messageContext.getProperty("callerSubject");
            if (subject == null) {
                this.logger.error((Object)"Unable to find calling subject");
                throw new GCUBEUnrecoverableException("Unable to find calling subject");
            }
            this.logger.debug((Object)("External calling subject " + subject));
            Set<Principal> principals = subject.getPrincipals();
            if (principals == null) {
                this.logger.error((Object)"Unable to find subject identity");
                throw new GCUBEUnrecoverableException("Unable to find subject identity");
            }
            try {
                String containerDn = ((Object)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials().getName()).toString();
                if (!this.checkDN(principals, containerDn)) {
                    throw new GCUBEUnrecoverableException((Throwable)new AuthorizationException("Authorization failed"));
                }
            }
            catch (GSSException e) {
                this.logger.error((Object)"Unable to control the dns", (Throwable)e);
            }
        } else {
            this.logger.debug((Object)"Security not enabled, nothing to do");
        }
    }

    private boolean checkDN(Set<Principal> principals, String containerDn) {
        this.logger.debug((Object)("Comparing the DN with " + containerDn));
        Iterator<Principal> principalIterator = principals.iterator();
        boolean found = false;
        containerDn = containerDn.trim();
        while (principalIterator.hasNext() && !found) {
            String dn = principalIterator.next().getName();
            this.logger.debug((Object)("Comparing with " + dn));
            if (!dn.equals(containerDn)) continue;
            found = true;
        }
        this.logger.debug((Object)("Found " + found));
        return found;
    }
}

