/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.handlers.utils;

import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.gcube.common.vomanagement.security.authorisation.handlers.utils.ExtendedWSConstants;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityRequestEngine;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLAssertionWSSecurityRequestEngine
extends WSSecurityRequestEngine {
    private static Log log = LogFactory.getLog((String)SAMLAssertionWSSecurityRequestEngine.class.getName());
    private static SAMLAssertionWSSecurityRequestEngine engine;

    public static synchronized SAMLAssertionWSSecurityRequestEngine getEngine() {
        if (engine == null) {
            engine = new SAMLAssertionWSSecurityRequestEngine();
        }
        return engine;
    }

    private SAMLAssertionWSSecurityRequestEngine() {
    }

    public void processSecurityHeader(Element securityHeader, MessageContext msgCtx, String actor, SOAPHeaderElement messageIdHeader, boolean request) throws Exception {
        boolean route;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing WS-Security header for '" + actor + "' actor." + " request (so process timestamp) " + request));
        }
        Element timestampElem = null;
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        String ns = null;
        String ln = null;
        for (int i = 0; i < len; ++i) {
            Node elem = list.item(i);
            ns = elem.getNamespaceURI();
            ln = elem.getLocalName();
            if ("http://www.w3.org/2000/09/xmldsig#".equalsIgnoreCase(ns) && "Signature".equalsIgnoreCase(ln)) {
                log.debug((Object)"Found signature element");
                if (this.handleSignatureElement((Element)elem, msgCtx, request)) continue;
                throw new WSSecurityException(6);
            }
            if ("http://www.w3.org/2001/04/xmlenc#".equalsIgnoreCase(ns)) {
                log.debug((Object)"Found encryption element");
                this.handleEncryptionElement((Element)elem, msgCtx);
                continue;
            }
            if ("UsernameToken".equalsIgnoreCase(ln)) {
                log.debug((Object)"Found user name token");
                this.handleUsernameElement((Element)elem, msgCtx);
                continue;
            }
            if ("Assertion".equalsIgnoreCase(ln) && "urn:oasis:names:tc:SAML:1.0:assertion".equalsIgnoreCase(ns)) {
                log.debug((Object)"Found SAML Assertion");
                this.handleSAMLAssertionElement((Element)elem, msgCtx);
                continue;
            }
            if (ExtendedWSConstants.WSU_NS.equalsIgnoreCase(ns) && "Timestamp".equalsIgnoreCase(ln)) {
                log.debug((Object)"Found timestamp element");
                timestampElem = (Element)elem;
                SAMLAssertionWSSecurityRequestEngine.normalize((Node)timestampElem);
                continue;
            }
            if (elem.getNodeType() != 1) continue;
            log.debug((Object)(elem.getLocalName() + " " + elem.getNamespaceURI()));
        }
        if (request) {
            log.debug((Object)"Secure message, timestamp might be required");
            if (this.constantSet(msgCtx.getProperty("org.globus.security.secMsg.msg.type"), Constants.SIGNATURE) || this.constantSet(msgCtx.getProperty("org.globus.security.secMsg.msg.type"), Constants.ENCRYPTION)) {
                this.processTimestampHeader(timestampElem, msgCtx, messageIdHeader);
            }
        }
        boolean bl = route = "".equals(actor) && Boolean.TRUE.equals(msgCtx.getProperty("org.globus.ogsa.router"));
        if (!route) {
            securityHeader.getParentNode().removeChild(securityHeader);
            log.debug((Object)"Security Header removed");
        } else {
            log.debug((Object)"Header not removed");
        }
    }

    private boolean constantSet(Object msgVal, Object propValue) {
        return msgVal != null && msgVal.equals(propValue);
    }

    private void handleSAMLAssertionElement(Element assertionElement, MessageContext context) throws Exception {
        if (assertionElement != null) {
            log.debug((Object)"Generating assertion object...");
            SAMLAssertion assertion = new SAMLAssertion(assertionElement);
            context.setProperty("org.globus.security.authorization.samlAssertion", (Object)assertion);
            log.debug((Object)"Assertion object inserted in the context");
        } else {
            log.error((Object)"Assertion element null");
        }
    }
}

