/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.impl.simple;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicy;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicyFactory;
import org.gcube.common.vomanagement.security.authorisation.core.PolicySerializationException;
import org.gcube.common.vomanagement.security.authorisation.core.impl.XStreamPolicySerializationHelper;

public abstract class ComplexPolicy
implements GCUBEPolicy {
    protected List<GCUBEPolicy> policies;

    public ComplexPolicy(GCUBEPolicy ... policies) {
        this.policies = new ArrayList<GCUBEPolicy>(Arrays.asList(policies));
    }

    @Override
    public void initialise(GCUBEServiceContext context) throws Exception {
        for (GCUBEPolicy policy : this.policies) {
            policy.initialise(context);
        }
    }

    @Override
    public void initialise(GCUBEServiceContext context, String policyContent) throws Exception {
        XStreamPolicySerializationHelper helper = new XStreamPolicySerializationHelper(new XStream());
        List<String> serializedPolicies = helper.getPolicyList(policyContent);
        GCUBEPolicyFactory factory = (GCUBEPolicyFactory)GHNContext.getImplementation(GCUBEPolicyFactory.class);
        factory.initialise(context);
        for (String policyExpression : serializedPolicies) {
            this.policies.add(factory.getGCUBEPolicy(policyExpression));
        }
    }

    @Override
    public String serialize() throws PolicySerializationException {
        XStreamPolicySerializationHelper helper = new XStreamPolicySerializationHelper(new XStream());
        ArrayList<String> serializedPolicies = new ArrayList<String>();
        for (GCUBEPolicy policy : this.policies) {
            serializedPolicies.add(policy.serialize());
        }
        String content = helper.getPolicyContent(serializedPolicies);
        return helper.getPolicyExpression(this.getClass().getCanonicalName(), content);
    }
}

