/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.impl.simple;

import com.thoughtworks.xstream.XStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicy;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicyEvaluationResponse;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationException;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationRequest;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationResponse;
import org.gcube.common.vomanagement.security.authorisation.core.PolicySerializationException;
import org.gcube.common.vomanagement.security.authorisation.core.impl.XStreamPolicySerializationHelper;
import org.gcube.common.vomanagement.security.authorisation.impl.simple.GCUBEGhnListPIP;
import org.gcube.common.vomanagement.security.authorisation.impl.simple.GHNCredentials;

public class TrustedGHNPolicy
implements GCUBEPolicy {
    protected GCUBELog logger = new GCUBELog((Object)this);
    private GCUBEServiceContext context;
    private GCUBEGhnListPIP ghnListPIP;
    private XStreamPolicySerializationHelper helper = new XStreamPolicySerializationHelper(new XStream());

    @Override
    public void initialise(GCUBEServiceContext context) throws Exception {
        this.logger.info((Object)("initialising TrustedGHNPolicy for service " + context.getServiceClass() + ":" + context.getName()));
        this.context = context;
        this.ghnListPIP = GCUBEGhnListPIP.getInstance(context);
    }

    @Override
    public void initialise(GCUBEServiceContext context, String policyContent) throws Exception {
        this.initialise(context);
    }

    @Override
    public PolicyEvaluationResponse evaluate(PolicyEvaluationRequest authzRequest) throws PolicyEvaluationException {
        Set<GHNCredentials> hosts = null;
        try {
            hosts = this.getGHNCredentialsFrom(this.ghnListPIP.getGHNListForScope(this.context.getScope()));
        }
        catch (Exception e) {
            throw new PolicyEvaluationException(e);
        }
        String dn = authzRequest.getSubjectAttributes().get("subject.dn");
        String ca = authzRequest.getSubjectAttributes().get("subject.ca");
        GHNCredentials callerCredentials = new GHNCredentials(dn, ca);
        for (GHNCredentials credentials : hosts) {
            if (!credentials.equals(callerCredentials)) continue;
            this.logger.debug((Object)("Authorized call from " + callerCredentials));
            return new GCUBEPolicyEvaluationResponse(PolicyEvaluationResponse.RESPONSE.PERMIT);
        }
        this.logger.warn((Object)("The caller host with credentials " + callerCredentials + " is not part of the trusted network for scope " + this.context.getScope()));
        return new GCUBEPolicyEvaluationResponse(PolicyEvaluationResponse.RESPONSE.DENY);
    }

    protected Set<GHNCredentials> getGHNCredentialsFrom(List<GCUBEHostingNode> ghns) {
        HashSet<GHNCredentials> hostnames = new HashSet<GHNCredentials>();
        for (GCUBEHostingNode ghn : ghns) {
            if (ghn.getNodeDescription().isSecurityEnabled()) {
                String ca = ghn.getNodeDescription().getSecurityData().getCA();
                String dn = ghn.getNodeDescription().getSecurityData().getCredentialsDistinguishedName();
                GHNCredentials creds = new GHNCredentials(dn, ca);
                hostnames.add(creds);
                this.logger.info((Object)("Added " + ghn.getNodeDescription().getName() + " with credentials " + creds + " to the trusted set"));
                continue;
            }
            this.logger.info((Object)("The host " + ghn.getNodeDescription().getName() + " is not trusted (security is disabled) "));
        }
        return hostnames;
    }

    @Override
    public String serialize() throws PolicySerializationException {
        return this.helper.getPolicyExpression(this.getClass().getCanonicalName(), "");
    }

    public String toString() {
        return "trustedGHNs";
    }
}

