/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.configuration;

import java.rmi.Remote;
import org.apache.axis.client.Stub;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.configuration.GCUBEServiceSecurityConfigurationManager;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;

public class GCUBEHostCredentialServiceSecurityManager
extends GCUBEServiceSecurityConfigurationManager {
    private GCUBELog logger = new GCUBELog((Object)this);
    private ExtendedGSSCredential internalCredentials;

    @Override
    public void initialise(GCUBEServiceContext ctxt) throws Exception {
        this.logger.debug((Object)"Initializing");
        super.initialise(ctxt);
        this.logger.debug((Object)"Adding host credentials");
        this.internalCredentials = (ExtendedGSSCredential)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials();
        this.logger.debug((Object)"Host credentials added");
    }

    public SecurityCredentials getCallerCredentials() throws Exception {
        this.logger.warn((Object)"No caller credential management supported in this security manager");
        return null;
    }

    public boolean needServiceCredentials() {
        return false;
    }

    public void useCredentials(SecurityCredentials credentials) throws Exception {
        this.logger.warn((Object)"The only credentials to be user are configured in the jndi");
    }

    public void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        this.logger.warn((Object)"The only credentials to be user are configured in the jndi");
    }

    public SecurityCredentials getCredentials() {
        return new GSSSecurityCredentials((GSSCredential)this.internalCredentials);
    }

    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        this.logger.debug((Object)("setting security parameters for service " + this.context.getService().getServiceName()));
        if (this.isSecurityEnabled()) {
            Stub stub = (Stub)s;
            stub._setProperty("org.globus.gsi.credentials", (Object)this.internalCredentials);
            String authMethodString = null;
            if (this.authMethod == GCUBESecurityManager.AuthMethod.GSI_CONV) {
                this.logger.debug((Object)"GSI Secure conversation");
                authMethodString = "org.globus.security.secConv.msg.type";
                this.logger.debug((Object)"Setting delegation...");
                this.logger.debug((Object)("delegation " + e));
                switch (d) {
                    case FULL: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsifull");
                        break;
                    }
                    case LIMITED: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsilimited");
                    }
                }
            } else {
                this.logger.debug((Object)"GSI Secure transport");
                authMethodString = "org.globus.security.transport.type";
            }
            switch (e) {
                case INTEGRITY: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    break;
                }
                case PRIVACY: {
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                    break;
                }
                case BOTH: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                }
            }
            this.logger.debug((Object)("Setting authentication GSI sec transport= " + e.name() + " on " + stub.getClass().getSimpleName()));
        } else {
            this.logger.debug((Object)"Security not enabled, nothing to do");
        }
    }
}

