/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.configuration.client;

import java.rmi.Remote;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.client.Stub;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.core.impl.SAMLSecurityCredentials;
import org.gcube.common.vomanagement.security.authorisation.handlers.utils.SAMLAuthzAssertionTokenBuilder;
import org.gcube.common.vomanagement.security.authorisation.utils.AssertionGenerator;
import org.gcube.common.vomanagement.security.configuration.client.GCUBEClientSecurityConfigurationManager;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.opensaml.SAMLAssertion;

public class GCUBESamlAssertionClientSecurityManager
extends GCUBEClientSecurityConfigurationManager {
    protected GCUBELog logger;
    protected Map<Thread, SAMLAssertion> callCredentials = Collections.synchronizedMap(new WeakHashMap());

    public GCUBESamlAssertionClientSecurityManager() {
        this.logger = new GCUBELog((Object)this);
    }

    @Override
    public void setIdentityParameters(Map<String, String> parameters) throws Exception {
        super.setIdentityParameters(parameters);
        this.initSamlAssertion();
        this.logger.debug((Object)("Identity " + this.identity));
    }

    @Override
    public void setDefaultIdentityParameter(String identity) throws Exception {
        super.setDefaultIdentityParameter(identity);
        this.initSamlAssertion();
        this.logger.debug((Object)("Identity " + identity));
    }

    public void useCredentials(SecurityCredentials credentials) throws Exception {
        this.useCredentials(Thread.currentThread(), credentials);
    }

    public void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        if (!this.isSecurityEnabled()) {
            return;
        }
        if (credentials.length == 0 || !this.checkCredentialType(credentials)) {
            credentials = new SecurityCredentials[]{this.getCredentials()};
        }
        try {
            SAMLAssertion assertionCredentials = (SAMLAssertion)credentials[0].getCredentialsAsObject();
            this.logger.debug((Object)("Using credentials of the assertion (" + assertionCredentials.getAssertionID() + ") in thread " + thread.getName() + "(" + thread.getId() + ")"));
            this.callCredentials.put(thread, assertionCredentials);
        }
        catch (ClassCastException e) {
            this.logger.error((Object)("Invalid credentials: expected SAML Assertion Credentials and found " + credentials[0].getCredentialsAsObject().getClass()));
        }
    }

    private boolean checkCredentialType(SecurityCredentials[] credentials) {
        this.logger.debug((Object)"Cheching credentials type");
        boolean found = false;
        for (SecurityCredentials c : credentials) {
            if (c instanceof SAMLSecurityCredentials) continue;
            found = true;
            break;
        }
        this.logger.debug((Object)("Credentials ok " + found));
        return !found;
    }

    public SecurityCredentials getCredentials() {
        SAMLAssertion internalCred = this.callCredentials.get(Thread.currentThread());
        if (internalCred != null) {
            this.logger.debug((Object)"Credentials found for the current thread");
            return new SAMLSecurityCredentials(internalCred);
        }
        this.logger.debug((Object)"Credentials not set, using service credentials");
        return this.getClientBaseCredentials();
    }

    private void initSamlAssertion() throws Exception {
        this.logger.debug((Object)"Initializing SAML Assertion");
        AssertionGenerator samlAssertionGenerator = new AssertionGenerator();
        samlAssertionGenerator.setLifetimeSec(5000);
        samlAssertionGenerator.setUserId(this.identity);
        samlAssertionGenerator.addRole(this.identity);
        SAMLAssertion assertion = samlAssertionGenerator.generate();
        this.clientBaseCredentials = new SAMLSecurityCredentials(assertion);
        this.logger.debug((Object)"SAML Assertion set");
    }

    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        this.logger.debug((Object)("setting security parameters for client " + this.identity));
        if (this.isSecurityEnabled()) {
            Stub stub = (Stub)s;
            stub._setProperty("org.globus.gsi.credentials", (Object)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials());
            SAMLSecurityCredentials credentials = (SAMLSecurityCredentials)this.getCredentials();
            if (credentials != null && credentials.getAssertion() != null) {
                this.logger.debug((Object)"setting SAML assertion");
                stub._setProperty("org.globus.security.authorization.samlAssertion", (Object)credentials.getAssertion());
                this.logger.debug((Object)"SAML assertion set");
            } else {
                this.logger.error((Object)"credentials or assertion not found");
            }
            String authMethodString = null;
            if (this.authMethod == GCUBESecurityManager.AuthMethod.GSI_CONV) {
                this.logger.debug((Object)"GSI Secure conversation");
                authMethodString = "org.globus.security.secConv.msg.type";
                this.logger.debug((Object)"Setting delegation...");
                this.logger.debug((Object)("delegation " + e));
                switch (d) {
                    case FULL: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsifull");
                        break;
                    }
                    case LIMITED: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsilimited");
                    }
                }
            } else {
                this.logger.debug((Object)"GSI Secure transport");
                authMethodString = "org.globus.security.transport.type";
            }
            switch (e) {
                case INTEGRITY: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    break;
                }
                case PRIVACY: {
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                    break;
                }
                case BOTH: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                }
            }
            this.logger.debug((Object)("Setting authentication GSI sec transport= " + e.name() + " on " + stub.getClass().getSimpleName()));
        } else {
            this.logger.debug((Object)"Security not enabled, nothing to do");
        }
    }

    public static void main(String[] args) throws Exception {
        AssertionGenerator samlAssertionGenerator = new AssertionGenerator();
        samlAssertionGenerator.setLifetimeSec(5000);
        samlAssertionGenerator.setUserId("ciro");
        samlAssertionGenerator.addRole("admin");
        SAMLAssertion assertion = samlAssertionGenerator.generate();
        org.apache.axis.message.SOAPEnvelope envelope = new org.apache.axis.message.SOAPEnvelope();
        SAMLAuthzAssertionTokenBuilder builder = new SAMLAuthzAssertionTokenBuilder(assertion);
        SOAPMessage newM = builder.buildMessage((SOAPEnvelope)envelope);
        Iterator headers = newM.getSOAPHeader().getChildElements();
        while (headers.hasNext()) {
            SOAPElement element = (SOAPElement)headers.next();
            System.out.println(element.getNodeName());
            System.out.println(element.getClass());
        }
    }
}

