/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.configuration.client;

import java.rmi.Remote;
import java.util.Map;
import org.apache.axis.client.Stub;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.security.utils.ProxyUtil;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.configuration.client.GCUBEClientSecurityConfigurationManager;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.ietf.jgss.GSSCredential;

public class GCubeProxyCertificateClientSecurityManager
extends GCUBEClientSecurityConfigurationManager {
    private GCUBELog logger = new GCUBELog((Object)this);
    private GSSCredential internalCredentials;

    @Override
    public void setDefaultIdentityParameter(String identity) throws Exception {
        super.setDefaultIdentityParameter(identity);
        this.internalCredentials = ProxyUtil.loadProxyCredentials((String)this.identity);
    }

    @Override
    public void setIdentityParameters(Map<String, String> parameters) throws Exception {
        super.setIdentityParameters(parameters);
        this.internalCredentials = ProxyUtil.loadProxyCredentials((String)this.identity);
    }

    public void useCredentials(SecurityCredentials credentials) throws Exception {
        this.logger.warn((Object)("Only proxy " + this.identity + " is used"));
    }

    public void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        this.logger.warn((Object)("Only proxy " + this.identity + " is used"));
    }

    public SecurityCredentials getCredentials() {
        return new GSSSecurityCredentials(this.internalCredentials);
    }

    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        this.logger.debug((Object)"setting security parameters for the client");
        if (this.isSecurityEnabled()) {
            Stub stub = (Stub)s;
            stub._setProperty("org.globus.gsi.credentials", (Object)this.internalCredentials);
            String authMethodString = null;
            if (this.authMethod == GCUBESecurityManager.AuthMethod.GSI_CONV) {
                this.logger.debug((Object)"GSI Secure conversation");
                authMethodString = "org.globus.security.secConv.msg.type";
                this.logger.debug((Object)"Setting delegation...");
                this.logger.debug((Object)("delegation " + e));
                switch (d) {
                    case FULL: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsifull");
                        break;
                    }
                    case LIMITED: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsilimited");
                    }
                }
            } else {
                this.logger.debug((Object)"GSI Secure transport");
                authMethodString = "org.globus.security.transport.type";
            }
            switch (e) {
                case INTEGRITY: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    break;
                }
                case PRIVACY: {
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                    break;
                }
                case BOTH: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                }
            }
            this.logger.debug((Object)("Setting authentication GSI sec transport= " + e.name() + " on " + stub.getClass().getSimpleName()));
        } else {
            this.logger.debug((Object)"Security not enabled, nothing to do");
        }
    }
}

