/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages;

import com.sun.xacml.Obligation;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseContextFactory {
    public static ResponseCtx generateResponseCtx(Element responseElement) throws ParsingException {
        HashSet<Result> results = new HashSet<Result>();
        NodeList nodes = responseElement.getElementsByTagNameNS("urn:oasis:names:tc:xacml:2.0:context:schema:os", "Result");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            if (!node.getLocalName().equals("Result")) continue;
            results.add(ResponseContextFactory.generateResult(node));
        }
        if (results.size() == 0) {
            throw new ParsingException("must have at least one Result");
        }
        return new ResponseCtx(results);
    }

    public static Result generateResult(Element resultElement) throws ParsingException {
        int decision = -1;
        Status status = null;
        String resource = null;
        Set<Obligation> obligations = null;
        NamedNodeMap attrs = resultElement.getAttributes();
        Node resourceAttr = attrs.getNamedItem("ResourceId");
        if (resourceAttr != null) {
            resource = resourceAttr.getNodeValue();
        }
        NodeList nodes = resultElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String namespace = node.getNamespaceURI();
            if (!(node instanceof Element) || !namespace.equals("urn:oasis:names:tc:xacml:2.0:context:schema:os")) continue;
            String name = node.getLocalName();
            if (name.equals("Decision")) {
                String type = node.getFirstChild().getNodeValue();
                for (int j = 0; j < Result.DECISIONS.length; ++j) {
                    if (!Result.DECISIONS[j].equals(type)) continue;
                    decision = j;
                    break;
                }
                if (decision != -1) continue;
                throw new ParsingException("Unknown Decision: " + type);
            }
            if (name.equals("Status")) {
                status = ResponseContextFactory.getStatus((Element)node);
                continue;
            }
            if (!name.equals("Obligations")) continue;
            obligations = ResponseContextFactory.parseObligations((Element)node);
        }
        return new Result(decision, status, resource, obligations);
    }

    public static Status getStatus(Element statusElement) throws ParsingException {
        List<String> code = null;
        String message = null;
        NodeList nodes = statusElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getLocalName();
            if (name.equals("StatusCode")) {
                code = ResponseContextFactory.parseStatusCode(node);
                continue;
            }
            if (!name.equals("StatusMessage")) continue;
            message = node.getFirstChild().getNodeValue();
        }
        return new Status(code, message, null);
    }

    private static List<String> parseStatusCode(Node root) {
        String val = root.getAttributes().getNamedItem("Value").getNodeValue();
        ArrayList<String> code = new ArrayList<String>();
        code.add(val);
        NodeList list = ((Element)root).getElementsByTagNameNS("urn:oasis:names:tc:xacml:2.0:context:schema:os", "StatusCode");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            code.add(node.getAttributes().getNamedItem("Value").getNodeValue());
        }
        return code;
    }

    private static Set<Obligation> parseObligations(Element root) throws ParsingException {
        HashSet<Obligation> set = new HashSet<Obligation>();
        NodeList nodes = root.getElementsByTagNameNS("urn:oasis:names:tc:xacml:2.0:context:schema:os", "Obligation");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            if (!node.getLocalName().equals("Obligation")) continue;
            set.add(ResponseContextFactory.generateObligation(node));
        }
        if (set.size() == 0) {
            throw new ParsingException("ObligationsType must not be empty");
        }
        return set;
    }

    public static Obligation generateObligation(Element obligationElement) throws ParsingException {
        URI id;
        int fulfillOn = -1;
        ArrayList<Attribute> assignments = new ArrayList<Attribute>();
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        NamedNodeMap attrs = obligationElement.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("ObligationId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attriubte ObligationId", (Throwable)e);
        }
        String effect = null;
        try {
            effect = attrs.getNamedItem("FulfillOn").getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attriubte FulfillOn", (Throwable)e);
        }
        if (effect.equals("Permit")) {
            fulfillOn = 0;
        } else if (effect.equals("Deny")) {
            fulfillOn = 1;
        } else {
            throw new ParsingException("Invlid Effect type: " + effect);
        }
        NodeList nodes = obligationElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getLocalName().equals("AttributeAssignment")) continue;
            try {
                URI attrId = new URI(node.getAttributes().getNamedItem("AttributeId").getNodeValue());
                AttributeValue attrValue = attrFactory.createValue(node);
                assignments.add(new Attribute(attrId, null, null, attrValue));
                continue;
            }
            catch (URISyntaxException use) {
                throw new ParsingException("Error parsing URI", (Throwable)use);
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown AttributeId", (Throwable)uie);
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing attribute assignments", (Throwable)e);
            }
        }
        return new Obligation(id, fulfillOn, assignments);
    }
}

