/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.soap;

import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.ResponseCtx;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages.ResponseContextFactory;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.soap.LowLevelSoapConnectionEngine;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SoapAxisConnectionEngine
implements LowLevelSoapConnectionEngine {
    private URL targetUrl;
    private Document bodyDocument;
    private GCUBELog logger = new GCUBELog((Object)this);

    @Override
    public void setTargetUrl(String targetUrl) throws MalformedURLException {
        this.targetUrl = new URL(targetUrl);
    }

    @Override
    public void setBodyDocument(Document bodyDocument) {
        this.bodyDocument = bodyDocument;
    }

    @Override
    public ResponseCtx sendMessage() throws Exception {
        this.logger.debug((Object)("Sending authorization request to " + this.targetUrl));
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(this.targetUrl);
        if (this.targetUrl.getProtocol().equalsIgnoreCase("https")) {
            this.logger.debug((Object)"Secure protocol called: inserting credentials");
            call.setProperty("org.globus.gsi.credentials", (Object)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials());
            call.setProperty("org.globus.security.transport.type", (Object)Constants.SIGNATURE);
            call.setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
            this.logger.debug((Object)"Secure protocol called: credentials inserted");
        }
        Object[] input = new SOAPBodyElement[]{new SOAPBodyElement(this.bodyDocument.getDocumentElement())};
        this.logger.debug((Object)"soap message generated");
        Vector elems = (Vector)call.invoke(input);
        this.logger.debug((Object)"response received");
        SOAPBodyElement elem = (SOAPBodyElement)elems.get(0);
        Element response = elem.getAsDOM();
        NodeList responseNodes = response.getElementsByTagNameNS("urn:oasis:names:tc:xacml:2.0:context:schema:os", "Response");
        this.logger.debug((Object)"Response object obtained");
        if (responseNodes.getLength() == 0) {
            throw new ParsingException("No Response nodes");
        }
        ResponseCtx responseCtx = ResponseContextFactory.generateResponseCtx((Element)responseNodes.item(0));
        this.logger.debug((Object)"response context created");
        return responseCtx;
    }
}

