/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.impl.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.service.Consumer;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;

public class GCUBEGhnListPIP {
    private GCUBEServiceContext context;
    private static GCUBEGhnListPIP instance;
    private static Map<GCUBEScope, Scheduler> schedulers;

    public static synchronized GCUBEGhnListPIP getInstance(GCUBEServiceContext context) throws Exception {
        if (instance == null) {
            instance = new GCUBEGhnListPIP(context);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GCUBEGhnListPIP(GCUBEServiceContext context) throws Exception {
        this.context = context;
        for (GCUBEScope scope : context.getInstance().getScopes().values()) {
            context.getLogger().trace((Object)("acquiring trusted GHNs in " + scope));
            Map<GCUBEScope, Scheduler> map = schedulers;
            synchronized (map) {
                Scheduler s = schedulers.get(scope);
                if (s == null) {
                    s = new Scheduler(scope);
                    s.run();
                    Scheduler scheduler = s;
                    synchronized (scheduler) {
                        ((Object)((Object)s)).wait();
                        if (s.getTrustedGHNs() == null) {
                            throw new Exception("cannot acquire trusted gHN list from IS for scope " + scope);
                        }
                    }
                    schedulers.put(scope, s);
                } else {
                    context.getLogger().trace((Object)("increasing sharing for GCUBEGhnListPIP in " + scope));
                    s.increaseSharing();
                }
                try {
                    context.subscribeLifetTime((Consumer)new RIMonitor(s), new GCUBEServiceContext.RILifetimeTopic[]{GCUBEServiceContext.RILifetimeTopic.FAILED});
                }
                catch (Exception e) {
                    context.getLogger().warn((Object)"could not subscribe GCUBEGhnListPIP to RI lifetime");
                }
            }
        }
    }

    public GCUBEServiceContext getContext() {
        return this.context;
    }

    public void setContext(GCUBEServiceContext context) {
        this.context = context;
    }

    public List<GCUBEHostingNode> getGHNListForScope(GCUBEScope scope) throws Exception {
        Scheduler s = schedulers.get(scope);
        if (s == null) {
            this.context.getLogger().warn((Object)"received call in unexpected RI scope");
            throw new Exception("cannot process policy in this scope");
        }
        return s.getTrustedGHNs();
    }

    private List<GCUBEHostingNode> getDummyGHNList() {
        ArrayList<GCUBEHostingNode> nodes = new ArrayList<GCUBEHostingNode>();
        try {
            GCUBEHostingNode node = (GCUBEHostingNode)GHNContext.getImplementation(GCUBEHostingNode.class);
            node.getNodeDescription().getSecurityData().setCA("/O=Grid/OU=GlobusTest/OU=simpleCA-gauss.eng.it/CN=Globus Simple CA");
            node.getNodeDescription().getSecurityData().setCredentialsDistinguishedName("/O=Grid/OU=GlobusTest/OU=simpleCA-gauss.eng.it/CN=grids05.eng.it");
            nodes.add(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nodes;
    }

    static {
        schedulers = new HashMap<GCUBEScope, Scheduler>();
    }

    private class Scheduler
    extends GCUBEScheduledHandler<GCUBEScope> {
        private long POLLING_INTERVAL;
        private static final int ATTEMPTS_AT_START = 3;
        private List<GCUBEHostingNode> ghns;
        private short sharing;

        Scheduler(GCUBEScope s) {
            super(0L, GCUBEScheduledHandler.Mode.LAZY, new GCUBEHandler[0]);
            this.POLLING_INTERVAL = GHNContext.getContext().getTrustedGHNSynchInterval();
            this.sharing = 1;
            this.setScheduled(new QueryTask(s));
        }

        synchronized void increaseSharing() {
            this.sharing = (short)(this.sharing + 1);
        }

        synchronized void decreaseSharing() {
            this.sharing = (short)(this.sharing - 1);
            if (this.sharing == 0) {
                this.stop();
            }
        }

        synchronized List<GCUBEHostingNode> getTrustedGHNs() {
            return this.ghns;
        }

        private synchronized void setTrustedGHNs(List<GCUBEHostingNode> ghns) {
            this.ghns = ghns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean repeat(Exception exception, int exceptionCount) {
            this.setInterval(this.POLLING_INTERVAL);
            GCUBEGhnListPIP.this.context.getLogger().info((Object)("TrustedGHNSynchInterval set to " + this.getInterval() / 1000L + " seconds"));
            if (exception == null) {
                Scheduler scheduler = this;
                synchronized (scheduler) {
                    ((Object)((Object)this)).notify();
                }
                this.exceptionCount = 0;
                return true;
            }
            if (this.ghns == null && exceptionCount >= 3) {
                Scheduler scheduler = this;
                synchronized (scheduler) {
                    ((Object)((Object)this)).notify();
                }
                return false;
            }
            GCUBEGhnListPIP.this.context.getLogger().warn((Object)("could not refresh GCUBEGhnListPIP state (failure n." + this.exceptionCount + ")"), (Throwable)this.exception);
            return true;
        }

        private class QueryTask
        extends GCUBEHandler<GCUBEScope> {
            QueryTask(GCUBEScope s) {
                this.setHandled(s);
            }

            public void run() throws Exception {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBEGHNQuery query = (GCUBEGHNQuery)client.getQuery(GCUBEGHNQuery.class);
                Scheduler.this.setTrustedGHNs(client.execute((ISQuery)query, (GCUBEScope)this.getHandled()));
            }
        }
    }

    private class RIMonitor
    extends Consumer {
        Scheduler scheduler;

        RIMonitor(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        protected synchronized void onRIFailed(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            this.scheduler.decreaseSharing();
        }
    }
}

