/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.utils;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.SAMLAssertionConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLSubject;

public class AssertionGenerator
implements SAMLAssertionConstants {
    protected GCUBELog logger = new GCUBELog((Object)this);
    private String userId;
    private List<String> roles = new ArrayList<String>();
    private int lifeTimeSec = 28800;
    public static final int STANDARD_LIFETIME_SEC = 28800;

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void setRoleList(List<String> roleList) {
        this.roles = roleList;
    }

    public void resetRoleList() {
        this.roles.clear();
    }

    public void removeRole(String role) {
        this.roles.remove(role);
    }

    public void setLifetimeSec(int lifetimeSec) {
        this.lifeTimeSec = lifetimeSec;
    }

    public int getLifetimeSec() {
        return this.lifeTimeSec;
    }

    public SAMLAssertion generate() throws Exception {
        this.logger.debug((Object)"generating saml assertion...");
        this.logger.debug((Object)"generating subject...");
        ArrayList<String> confMethods = new ArrayList<String>();
        confMethods.add("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        this.logger.debug((Object)("subject name = " + this.userId));
        SAMLSubject subject = new SAMLSubject(this.userId, null, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", confMethods, null, null);
        Calendar notBefore = Calendar.getInstance();
        Calendar notOnOrAfter = Calendar.getInstance();
        if (this.lifeTimeSec > 0) {
            notOnOrAfter.add(13, this.lifeTimeSec);
        } else {
            notBefore.add(13, this.lifeTimeSec);
        }
        this.logger.debug((Object)"generating attributes...");
        ArrayList<SAMLAttribute> attributes = new ArrayList<SAMLAttribute>();
        if (!this.roles.isEmpty()) {
            ArrayList<String> roleValuesList = new ArrayList<String>();
            for (String role : this.roles) {
                this.logger.debug((Object)("adding role " + role));
                roleValuesList.add(role);
            }
            SAMLAttribute serviceIdAttribute = new SAMLAttribute("role.id", "urn:service.attributes", null, 0L, roleValuesList);
            attributes.add(serviceIdAttribute);
            this.logger.debug((Object)"attributes genarated");
        }
        this.logger.debug((Object)"completing statement...");
        SAMLAttributeStatement statement = new SAMLAttributeStatement(subject, attributes);
        ArrayList<SAMLAttributeStatement> statements = new ArrayList<SAMLAttributeStatement>();
        statements.add(statement);
        this.logger.debug((Object)"statement completed");
        SAMLAssertion assertion = new SAMLAssertion(this.userId, notBefore.getTime(), notOnOrAfter.getTime(), null, null, statements);
        this.logger.debug((Object)("saml assertion " + assertion + " generated"));
        return assertion;
    }

    public SAMLAssertion generateSignedAssertion() throws Exception {
        this.logger.debug((Object)"generating signed assertion...");
        SAMLAssertion assertion = this.generate();
        try {
            this.signAssertion(assertion);
            this.logger.debug((Object)"signature ok");
        }
        catch (Exception e) {
            this.logger.error((Object)"Error during signature process", (Throwable)e);
            this.logger.error((Object)"signature process failed");
        }
        this.logger.debug((Object)"assertion generated");
        return assertion;
    }

    private void signAssertion(SAMLAssertion assertion) throws Exception {
        this.logger.debug((Object)"starting signature process...");
        GlobusGSSCredentialImpl credential = (GlobusGSSCredentialImpl)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials();
        if (credential != null) {
            this.logger.debug((Object)("credential = " + credential));
            List<X509Certificate> certs = this.getCertificates(credential);
            if (certs != null) {
                assertion.sign("http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Key)credential.getPrivateKey(), certs, false);
            } else {
                this.logger.error((Object)"Certs not found");
                this.logger.error((Object)"Unable to sign the assertion");
            }
        } else {
            this.logger.error((Object)"Unable to sign SAML assertion");
            this.logger.error((Object)"Credentials not found");
        }
        this.logger.debug((Object)"signature process finished");
    }

    private List<X509Certificate> getCertificates(GlobusGSSCredentialImpl credential) {
        this.logger.debug((Object)"getting certificates...");
        X509Certificate[] certArray = credential.getCertificateChain();
        ArrayList<X509Certificate> certs = null;
        if (certArray.length > 0) {
            this.logger.debug((Object)"Cert array is not null");
            certs = new ArrayList<X509Certificate>();
            for (int i = 0; i < certArray.length; ++i) {
                certs.add(certArray[i]);
            }
        } else {
            this.logger.debug((Object)"Cert array is Null");
        }
        return certs;
    }

    public static void main(String[] args) throws Exception {
        AssertionGenerator generator = new AssertionGenerator();
        generator.setUserId("ciro");
        generator.addRole("administrator");
        generator.addRole("user");
        SAMLAssertion assertion = generator.generate();
        System.out.println(assertion);
    }

    static {
        GSSConfig.init();
    }
}

