/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.configuration.client;

import java.util.Map;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.security.GCUBEClientSecurityManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.ietf.jgss.GSSCredential;

public abstract class GCUBEClientSecurityConfigurationManager
implements GCUBEClientSecurityManager {
    protected SecurityCredentials clientBaseCredentials;
    protected int securityStatus = 0;
    protected String identity;
    protected GCUBELog logger = new GCUBELog((Object)this);
    protected GCUBESecurityManager.AuthMethod authMethod = GCUBESecurityManager.AuthMethod.GSI_TRANS;

    public void setDefaultIdentityParameter(String identity) throws Exception {
        this.logger.debug((Object)"Setting identity parameters");
        if (identity == null) {
            throw new Exception("Invalid configuration: identity null");
        }
        this.identity = identity;
        this.logger.debug((Object)("Identity " + identity));
    }

    public void setIdentityParameters(Map<String, String> parameters) throws Exception {
        this.logger.debug((Object)"Setting identity parameters");
        this.identity = parameters.get("IDENTITY");
        if (this.identity == null) {
            throw new Exception("Invalid configuration: identity null");
        }
        this.logger.debug((Object)("Identity " + this.identity));
    }

    @Deprecated
    public void useCredentials(GSSCredential credentials) throws Exception {
        this.useCredentials((SecurityCredentials)new GSSSecurityCredentials(credentials));
    }

    public boolean isSecurityEnabled() {
        boolean response = false;
        switch (this.securityStatus) {
            case 0: {
                this.logger.debug((Object)"Security status taken from conf file");
                response = GHNContext.getContext().isSecurityEnabled();
                break;
            }
            case 1: {
                this.logger.debug((Object)"Security forced");
                response = true;
                break;
            }
            case 2: {
                this.logger.debug((Object)"Security forced");
                response = false;
            }
        }
        this.logger.debug((Object)("Security enabled " + response));
        return response;
    }

    public void forceSecurityEnabled() {
        this.securityStatus = 1;
    }

    public void forceSecurityDisabled() {
        this.securityStatus = 2;
    }

    public void disableSecurityStatusEnforcement() {
        this.securityStatus = 0;
    }

    public SecurityCredentials getClientBaseCredentials() {
        return this.clientBaseCredentials;
    }

    public void setAuthMethod(GCUBESecurityManager.AuthMethod m) {
        this.authMethod = m;
    }
}

