/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.common.security.impl;

import it.eng.rdlab.soa3.connector.utils.SecurityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.common.security.Credentials;

public class X509TLSCredentials
implements Credentials {
    private Log log = LogFactory.getLog(this.getClass());
    private final String X509TLS = "X509TLS";
    private String certFile;
    private String keyFile;
    private String trustDir;

    public X509TLSCredentials() {
        this(null, null, null, null);
    }

    public X509TLSCredentials(String certFile, String keyFile, String trustDir, String trustExt) {
        if (certFile != null) {
            SecurityManager.getInstance().setCertFile(certFile);
            this.certFile = certFile;
        } else {
            this.certFile = "/etc/grid-security/hostcert.pem";
        }
        if (keyFile != null) {
            SecurityManager.getInstance().setKeyFile(keyFile);
            this.keyFile = keyFile;
        } else {
            this.keyFile = "/etc/grid-security/hostkey.pem";
        }
        if (trustDir != null) {
            SecurityManager.getInstance().setTrustDir(trustDir);
            this.trustDir = trustDir;
        } else {
            this.trustDir = "/etc/grid-security/certificates/";
        }
        if (trustExt != null) {
            SecurityManager.getInstance().setTrustExt(trustExt);
        }
    }

    @Override
    public void prepareCredentials() {
        this.log.debug((Object)"Loading certificates");
        try {
            SecurityManager.getInstance().loadCertificate();
            this.log.debug((Object)"Certificates loaded");
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to load security certificates", (Throwable)e);
        }
    }

    @Override
    public String getAuthenticationType() {
        return "X509TLS";
    }

    @Override
    public String getAuthenticationString() {
        return "Certificate " + this.certFile + " Key " + this.keyFile + " Trust Dir " + this.trustDir;
    }

    @Override
    public String getHeaderString() {
        return null;
    }
}

