package org.gcube.security.soa3.connector.integration.client.context;

import java.util.ArrayList;
import java.util.List;

import javax.security.auth.Subject;

import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManager.AuthMethod;
import org.gcube.common.core.security.context.SecurityContext;
import org.gcube.common.core.security.impl.GCUBECredentialAdder;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.ietf.jgss.GSSCredential;

public class SOA3ClientSecurityContext implements SecurityContext {

	private ServiceSecurityDescriptor secDesc;
	private GCUBEDefaultSecurityConfiguration configuration;
	
	public SOA3ClientSecurityContext ()
	{
		this.configuration = new GCUBEDefaultSecurityConfiguration();
		this.configuration.setOutEnabled(true);
		this.configuration.setOutOverride(true);
		
		secDesc = new ServiceSecurityDescriptor();
		List<AuthMethod> authMethods = new ArrayList<AuthMethod> ();
		authMethods.add(AuthMethod.GSI_TRANS);
		try {
			secDesc.setAuthMethods(authMethods);
		} catch (SecurityDescriptorException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	@Override
	public GCUBEDefaultSecurityConfiguration getDefaultServiceSecurityConfiguration() {

		return configuration;
	}

	@Override
	public ServiceSecurityDescriptor getDefaultIncomingMessagesSecurityDescriptor() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ServiceSecurityDescriptor getDefaultOutgoingMessagesSecurityDescriptor() {
		return secDesc;
	}

	@Override
	public Subject getDefaultSubject() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GSSCredential getDefaultCredentials() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GCUBESecurityManager getDefaultSecurityManager() throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GCUBECredentialAdder getCredentialsAdder() {
		// TODO Auto-generated method stub
		return null;
	}

}
