package org.gcube.security.soa3.connector.integration;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;

import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.common.security.Credentials;
import org.gcube.soa3.connector.common.security.messages.MessageManager;

/**
 * 
 * Specification of {@link MessageManager} class for REST messages
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class StubMessageManager implements MessageManager {

	private Log log;
	private Stub stub;
	public static final String 	BINARY_SECURITY_TOKEN_LABEL = "BinarySecurityToken",
								BINARY_SECURITY_TOKEN_PREFIX = "wsse",
								WSSE_NAMESPACE = "http://schemas.xmlsoap.org/ws/2002/04/secext",
								VALUE_TYPE_LABEL = "ValueType",
								ENCODING_TYPE_LABEL = "EncodingType",
								BASE64 = "wsse:Base64Binary",
								ID_LABEL = "Id",
								SECURITY_TOKEN = "SecurityToken";
							
	
	public StubMessageManager(Stub stub) 
	{
		this.log = LogFactory.getLog(this.getClass());
		this.stub = stub;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setCredentials(Credentials credentials) 
	{
		log.debug("Setting credentials..");
		credentials.prepareCredentials();
		String headerString = credentials.getHeaderString();
		log.debug("Header string = "+headerString);
		
		if (headerString != null)
		{
			log.debug("Inserting credentials string into the header");
			
			try 
			{
				log.debug("Inserting the header in the message");
				this.stub.setHeader(generateBinaryTokenElement(credentials.getAuthenticationType(), headerString));
				log.debug("Header added");
			}
			catch (SOAPException e)
			{
				log.error("Unable to generate token security header",e);
			}
		}
		else
		{
			log.debug("No headers to be inserted in the message");
		}
			
			
	}
	
	
	private SOAPHeaderElement generateBinaryTokenElement (String type,String binaryTokenValue) throws SOAPException
	{
		log.debug("Generating token SOAP element");
		log.debug("Type = "+type);
		log.debug("Value = "+binaryTokenValue);
		SOAPHeaderElement headerElement = new SOAPHeaderElement(new QName(WSSE_NAMESPACE,BINARY_SECURITY_TOKEN_PREFIX+":"+BINARY_SECURITY_TOKEN_LABEL));
		headerElement.addAttribute (WSSE_NAMESPACE,VALUE_TYPE_LABEL,type);
		headerElement.addAttribute (WSSE_NAMESPACE,ENCODING_TYPE_LABEL,BASE64);
		headerElement.addAttribute (WSSE_NAMESPACE,ID_LABEL,SECURITY_TOKEN);
		headerElement.setValue(binaryTokenValue);
		log.debug("Header completed");
		return headerElement;

	}

}
