package org.gcube.security.soa3.connector.integration;

import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.connector.integration.utils.Utils;
import org.gcube.soa3.connector.common.security.Credentials;
import org.gcube.soa3.connector.common.security.messages.impl.SoapMessageManager;
import org.w3c.dom.Element;

public class TokenCredentials implements SecurityCredentials {

	private GCUBELog log;
	
	private String 	type,
					value;
	
	public TokenCredentials (String type,String binaryTokenValue) 
	{
		this.log = new GCUBELog(this);
		this.type = type;
		this.value = binaryTokenValue;
	}
	
	public TokenCredentials (Element token)
	{
		this.type = token.getAttribute(SoapMessageManager.ENCODING_TYPE_LABEL);
		this.value = token.getAttribute(SoapMessageManager.ID_LABEL);
	}
	
	@Override
	public String getCredentialsAsString() throws Exception 
	{
		return type+ " "+value;
	}

	@Override
	public Object getCredentialsAsObject() {

		try
		{
		
			return Utils.generateBinaryTokenElement(type, value);
		} 
		catch (Exception e)
		{
			this.log.error("Unable to produce security token",e);
			return null;
		}
	}
	
	public String getType ()
	{
		return this.type;
	}
	
	public String getValue ()
	{
		return this.value;
	}

}
