/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration.server;

import java.rmi.Remote;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Stub;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.gcube.security.soa3.connector.integration.TokenCredentials;
import org.gcube.security.soa3.connector.integration.server.GCUBEServiceSecurityConfigurationManager;
import org.gcube.security.soa3.connector.integration.utils.Utils;
import org.gcube.soa3.connector.common.security.CredentialManager;
import org.gcube.soa3.connector.common.security.Credentials;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Element;

public class SOA3IntegrationServiceCredentialInserter
extends GCUBEServiceSecurityConfigurationManager {
    private GCUBELog log;
    private boolean isSecurityEnabled;
    private boolean propagateCallerCredentials = true;
    private GCUBEServiceContext context;
    protected Map<Thread, Element> callCredentials = Collections.synchronizedMap(new WeakHashMap());

    public SOA3IntegrationServiceCredentialInserter() {
        this.log = new GCUBELog((Object)this);
    }

    public boolean isSecurityEnabled() {
        return this.isSecurityEnabled;
    }

    @Override
    public void useCredentials(GSSCredential credentials) throws Exception {
    }

    public void useCredentials(SecurityCredentials credentials) throws Exception {
        this.useCredentials(Thread.currentThread(), credentials);
    }

    public void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        if (!this.isSecurityEnabled()) {
            return;
        }
        if (credentials.length == 0) {
            credentials = new SecurityCredentials[]{this.getCredentials()};
        }
        try {
            Element tokenCredentials = (Element)credentials[0].getCredentialsAsObject();
            this.log.debug((Object)("Using credentials of the token (" + credentials[0].getCredentialsAsString() + ") in thread " + thread.getName() + "(" + thread.getId() + ")"));
            this.callCredentials.put(thread, tokenCredentials);
        }
        catch (ClassCastException e) {
            this.log.error((Object)("Invalid credentials: expected Token Credentials and found " + credentials[0].getCredentialsAsObject().getClass()));
        }
    }

    public SecurityCredentials getCredentials() {
        Element internalCred = this.callCredentials.get(Thread.currentThread());
        if (internalCred != null) {
            this.log.debug((Object)"Credentials found for the current thread");
            return new TokenCredentials(internalCred);
        }
        if (this.propagateCallerCredentials) {
            this.log.debug((Object)"Credentials not set, using caller credentials");
            try {
                return this.getCallerCredentials();
            }
            catch (Exception e) {
                this.log.error((Object)"Unable to find caller credentials, probably the credentials are not available, disable the credential propagation in the service configuration", (Throwable)e);
                this.log.error((Object)"Trying to use service credentials");
            }
        }
        this.log.debug((Object)"Using service credentials");
        try {
            return this.getServiceCredentials();
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to find service credentials", (Throwable)e);
            this.log.error((Object)"No authorization credentials will be used");
            return null;
        }
    }

    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        this.log.debug((Object)("setting security parameters for service " + this.context.getService().getServiceName()));
        if (this.isSecurityEnabled()) {
            Stub stub = (Stub)s;
            stub._setProperty("org.globus.gsi.credentials", (Object)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials());
            TokenCredentials credentials = (TokenCredentials)this.getCredentials();
            if (credentials != null && credentials.getType() != null && credentials.getValue() != null) {
                this.log.debug((Object)"setting Security Token");
                stub.setHeader(Utils.generateSoapHeaderBinaryTokenElement(credentials.getType(), credentials.getValue()));
                this.log.debug((Object)"SAML assertion set");
            } else {
                this.log.error((Object)"credentials or token not found");
            }
            switch (e) {
                case INTEGRITY: {
                    stub._setProperty("org.globus.security.transport.type", (Object)Constants.SIGNATURE);
                    break;
                }
                case PRIVACY: {
                    stub._setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
                    break;
                }
                case BOTH: {
                    stub._setProperty("org.globus.security.transport.type", (Object)Constants.SIGNATURE);
                    stub._setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
                }
            }
            this.log.debug((Object)("Setting authentication GSI sec transport= " + e.name() + " on " + stub.getClass().getSimpleName()));
        } else {
            this.log.debug((Object)"Security not enabled, nothing to do");
        }
    }

    @Override
    public void initialise(GCUBEServiceContext ctxt) throws Exception {
        this.context = ctxt;
        String serviceName = ctxt.getName();
        this.log.debug((Object)("Service name " + serviceName));
        if (!ConfigurationManager.getInstance().servicePropertiesSet(serviceName)) {
            Utils.setServiceProperties(ctxt, serviceName);
        }
        this.isSecurityEnabled = ConfigurationManager.getInstance().isSecurityEnabled(ctxt.getName());
        this.propagateCallerCredentials(ConfigurationManager.getInstance().getCredentialPropagationPolicy(serviceName));
        this.log.debug((Object)"Init completed");
    }

    @Override
    public SecurityCredentials getServiceCredentials() throws Exception {
        Credentials credentials = CredentialManager.getInstance().getCredentials();
        return new TokenCredentials(credentials.getAuthenticationType(), credentials.getHeaderString());
    }

    public SecurityCredentials getCallerCredentials() throws Exception {
        return this.getCallerToken();
    }

    public boolean needServiceCredentials() {
        return true;
    }

    @Override
    public void propagateCallerCredentials(boolean propagateCallerCredentials) {
        this.propagateCallerCredentials = propagateCallerCredentials;
    }

    private TokenCredentials getCallerToken() {
        this.log.debug((Object)"getting caller Security Token...");
        MessageContext msgCtx = MessageContext.getCurrentContext();
        Element token = (Element)msgCtx.getProperty("SECURITY_TOKEN");
        TokenCredentials response = null;
        if (token == null) {
            this.log.warn((Object)"The Token is null!");
        } else {
            response = new TokenCredentials(token);
            try {
                this.log.debug((Object)("Token found = " + response.getCredentialsAsString()));
            }
            catch (Exception e) {
                this.log.error((Object)"Invalid token ", (Throwable)e);
            }
        }
        return response;
    }
}

