/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.utils;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;

public class SecurityManager {
    private Log log = LogFactory.getLog(this.getClass());
    private static SecurityManager instance;
    public static final String DEFAULT_CERT_FILE = "/etc/grid-security/hostcert.pem";
    public static final String DEFAULT_KEY_FILE = "/etc/grid-security/hostkey.pem";
    public static final String DEFAULT_TRUST_DIR = "/etc/grid-security/certificates/";
    public static final String DEFAULT_TRUST_FILE_EXTENSION = ".0";
    private String certFile;
    private String keyFile;
    private String trustDir;
    private String trustExt;
    private boolean invalidateTrustDirectory;
    private List<String> trustedCertificates;

    private SecurityManager() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.certFile = DEFAULT_CERT_FILE;
        this.keyFile = DEFAULT_KEY_FILE;
        this.trustDir = DEFAULT_TRUST_DIR;
        this.trustExt = DEFAULT_TRUST_FILE_EXTENSION;
        this.invalidateTrustDirectory = false;
        this.trustedCertificates = new ArrayList<String>();
    }

    public static SecurityManager getInstance() {
        if (instance == null) {
            instance = new SecurityManager();
        }
        return instance;
    }

    public void setCertFile(String certFile) {
        if (certFile != null) {
            this.certFile = certFile;
        }
    }

    public void setKeyFile(String keyFile) {
        if (keyFile != null) {
            this.keyFile = keyFile;
        }
    }

    public void setTrustDir(String trustDir) {
        if (trustDir != null) {
            if (!trustDir.endsWith("/")) {
                trustDir = trustDir + "/";
            }
            this.trustDir = trustDir;
        }
    }

    public void setTrustExt(String trustExt) {
        if (trustExt != null) {
            this.trustExt = trustExt;
        }
    }

    public void invalidateTrustedDir(boolean invalidate) {
        this.invalidateTrustDirectory = invalidate;
    }

    public void addTrustedCert(String file) {
        this.trustedCertificates.add(file);
    }

    private KeyStore getKeyStore() throws Exception {
        FileReader reader = new FileReader(this.keyFile);
        PEMReader pem = new PEMReader((Reader)reader);
        PrivateKey key = ((KeyPair)pem.readObject()).getPrivate();
        pem.close();
        reader.close();
        reader = new FileReader(this.certFile);
        pem = new PEMReader((Reader)reader);
        X509Certificate cert = (X509Certificate)pem.readObject();
        pem.close();
        reader.close();
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null);
        keystore.setKeyEntry("certs", key, "changeit".toCharArray(), new Certificate[]{cert});
        List<String> trustedCertFiles = this.getTrustedCerts();
        this.log.debug((Object)"trusted files");
        for (int i = 0; i < trustedCertFiles.size(); ++i) {
            this.log.debug((Object)trustedCertFiles.get(i));
            reader = new FileReader(trustedCertFiles.get(i));
            pem = new PEMReader((Reader)reader);
            X509Certificate trustCert = (X509Certificate)pem.readObject();
            pem.close();
            reader.close();
            keystore.setCertificateEntry("trust" + i, trustCert);
        }
        return keystore;
    }

    private List<String> getTrustedCerts() {
        ArrayList<String> response = new ArrayList<String>(this.trustedCertificates);
        if (!this.invalidateTrustDirectory) {
            this.log.debug((Object)"Reading the trust directory");
            File dir = new File(this.trustDir);
            String[] fileNames = dir.list();
            this.log.debug((Object)"Files in the trust directory");
            for (String fileName : fileNames) {
                this.log.debug((Object)fileName);
                if (!fileName.endsWith(this.trustExt)) continue;
                response.add(this.trustDir + fileName);
            }
        }
        return response;
    }

    public void loadCertificate() throws Exception {
        KeyStore keystore = this.getKeyStore();
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyFactory.init(keystore, "changeit".toCharArray());
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustFactory.init(keystore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyFactory.getKeyManagers(), trustFactory.getTrustManagers(), new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SecurityManager.getInstance().loadCertificate();
    }
}

