/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.common.security.impl;

import org.gcube.soa3.connector.common.security.CredentialManager;
import org.gcube.soa3.connector.common.security.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialManagerImpl
implements CredentialManager {
    private InheritableThreadLocal<Credentials> credentials;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    CredentialManagerImpl() {
        this.credentials = new InheritableThreadLocal();
    }

    @Override
    public void set(Credentials credentials) {
        this.logger.debug("Setting credentials for thread " + Thread.currentThread().getId());
        credentials.prepareCredentials();
        this.credentials.set(credentials);
    }

    @Override
    public Credentials get() {
        this.logger.debug("Getting credentials for thread " + Thread.currentThread().getId());
        return (Credentials)this.credentials.get();
    }

    @Override
    public void reset() {
        this.logger.debug("Resetting and disposing credentials for thread " + Thread.currentThread().getId());
        ((Credentials)this.credentials.get()).disposeCredentials();
        this.credentials.remove();
    }
}

