/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration.server;

import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.security.GCUBESecurityController;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.gcube.security.soa3.connector.SOA3SecurityController;
import org.gcube.security.soa3.connector.integration.utils.Utils;

public class SOA3IntegrationSecurityController
implements GCUBEServiceAuthorizationController {
    private GCUBELog log = new GCUBELog((Object)this);
    private GCUBESecurityController controller = new SOA3SecurityController();
    private boolean isSecurityEnabled = false;

    public void initialise(GCUBEServiceContext ctxt, GCUBEServiceSecurityManager securityManager) throws Exception {
        String serviceName = ctxt.getName();
        if (!ConfigurationManager.getInstance().servicePropertiesSet(serviceName)) {
            Utils.setServiceProperties(ctxt, serviceName);
        }
        this.log.debug((Object)"Initializing the controller");
        this.controller.init(ctxt);
        this.isSecurityEnabled = ConfigurationManager.getInstance().isSecurityEnabled(ctxt.getName());
        this.log.debug((Object)"Init completed");
        if (this.log.isDebugEnabled()) {
            Provider[] provs;
            for (Provider p : provs = Security.getProviders()) {
                this.log.debug((Object)("name " + p.getName()));
                this.log.debug((Object)("version " + p.getVersion()));
                this.log.debug(p.getClass());
                Set<Provider.Service> services = p.getServices();
                if (services == null || services.isEmpty()) continue;
                this.log.debug((Object)"Services:");
                for (Provider.Service s : services) {
                    this.log.debug((Object)s.getAlgorithm());
                }
                this.log.debug((Object)"********************");
            }
        }
    }

    public boolean isSecurityEnabled() {
        return this.isSecurityEnabled;
    }

    public void authoriseCall(Map<String, Object> parameters) throws GCUBEException {
        this.log.debug((Object)"Checking the privileges...");
        if (!this.controller.checkAccess(parameters)) {
            this.log.debug((Object)"Access not granted");
            throw new GCUBEUnrecoverableException("Security exception: the requirer is not authorized to perform the selected operation");
        }
        this.log.debug((Object)"Access granted");
    }
}

