/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.impl;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.ws.rs.core.MediaType;
import org.bouncycastle.util.encoders.Base64;
import org.gcube.security.soa3.cache.SOA3EhcacheWrapper;
import org.gcube.security.soa3.configuration.ConfigurationManagerFactory;
import org.gcube.security.soa3.connector.GCUBESecurityController;
import org.gcube.security.soa3.connector.engine.RestManager;
import org.gcube.security.soa3.connector.integration.utils.Utils;
import org.gcube.soa3.connector.common.security.CredentialManager;
import org.gcube.soa3.connector.common.security.Credentials;
import org.gcube.soa3.connector.common.security.impl.TicketCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SOA3SecurityController
implements GCUBESecurityController {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DN = "DN";
    private final String AUTHORIZATION_HEADER = "Authorization";
    private final String SERVICE_STRING_HEADER = "Servicestring";
    private final String SERVICE_INSTANCE_HEADER = "Serviceinstance";
    private String serviceName;
    private String defaultSoa3Endpoint;
    private boolean credentialPropagationPolicy;
    private boolean securityEnabled;

    @Override
    public void init(Map<String, String> parameters) {
        this.serviceName = parameters.get("SERVICE_NAME");
        this.log.debug("Initializing security manager for service " + this.serviceName);
        this.defaultSoa3Endpoint = ConfigurationManagerFactory.getConfigurationManager().getServerUrl(this.serviceName);
        this.credentialPropagationPolicy = ConfigurationManagerFactory.getConfigurationManager().getCredentialPropagationPolicy(this.serviceName);
        this.securityEnabled = ConfigurationManagerFactory.getConfigurationManager().isSecurityEnabled(this.serviceName);
    }

    @Override
    public boolean checkAccess(Map<String, Object> parameters) {
        this.log.debug("Checking access");
        if (!this.securityEnabled) {
            this.log.debug("Security disabled");
            return true;
        }
        this.log.debug("Security enabled");
        return this.applySecurityPolicies(parameters);
    }

    private boolean applySecurityPolicies(Map<String, Object> parameters) {
        this.log.debug("Checking the acces rights");
        String ticket = this.checkAccessPrivileges(parameters);
        this.log.debug("Response = " + ticket);
        this.setCredentials(ticket, parameters);
        return ticket != null;
    }

    private void setCredentials(String ticket, Map<String, Object> parameters) {
        this.log.debug("Setting credentials in the messageContext");
        if (ticket != null && this.credentialPropagationPolicy) {
            this.log.debug("Setting...");
            try {
                this.log.debug("Adding the credentials to the security manager");
                TicketCredentials credentials = new TicketCredentials(ticket);
                credentials.prepareCredentials();
                CredentialManager.instance.set((Credentials)credentials);
                this.log.debug("Generating security header");
                Element element = Utils.generateBinaryTokenElement(credentials.getAuthenticationType(), ticket);
                this.log.debug("Security Header generated");
                parameters.put("SECURITY_TOKEN", element);
            }
            catch (Exception e) {
                this.log.debug("Unable to generate the security header", (Throwable)e);
            }
        } else {
            this.log.debug("Propagation not set");
        }
    }

    private String checkAccessPrivileges(Map<String, Object> parameters) {
        this.log.debug("Get Credentials bean");
        String ticket = null;
        String securityHeader = (String)parameters.get("BinarySecurityToken");
        String serviceString = (String)parameters.get("SERVICE_STRING");
        String instance = (String)parameters.get("SERVICE_INSTANCE");
        this.log.debug("Security Header " + securityHeader);
        this.log.debug("Service string " + serviceString);
        this.log.debug("Service instance " + instance);
        if (securityHeader != null) {
            this.log.debug("Security Header not null");
            try {
                String[] secHeaderElements = securityHeader.split(" ");
                String type = secHeaderElements[0];
                String value = secHeaderElements[1];
                this.log.debug("Type = " + type);
                this.log.debug("id = " + value);
                ticket = this.performAuthentication(type, value, serviceString, instance);
            }
            catch (Exception e) {
                this.log.error("Invalid auth header, triyng to find DN");
                ticket = this.performDnBasedAuthentication((Subject)parameters.get("PEER_SUBJECT"), serviceString, instance);
                this.log.debug("ticket = " + ticket);
            }
        } else {
            this.log.debug("Security Header null, trying to find DN");
            ticket = this.performDnBasedAuthentication((Subject)parameters.get("PEER_SUBJECT"), serviceString, instance);
            this.log.debug("Ticket = " + ticket);
        }
        this.log.debug("Operation completed");
        return ticket;
    }

    private String performDnBasedAuthentication(Subject subject, String serviceString, String operationName) {
        this.log.debug("No security header found");
        this.log.debug("Looking for the Distinguished Name");
        String response = null;
        if (subject == null) {
            this.log.error("No Distinguished name found");
        } else {
            this.log.debug("External subject " + subject);
            Set<Principal> principals = subject.getPrincipals();
            if (principals == null || principals.isEmpty()) {
                this.log.error("Unable to find subject identity");
            } else {
                this.log.debug("Identities found, looking for the DNs");
                Iterator<Principal> principalIterator = principals.iterator();
                while (principalIterator.hasNext() && response == null) {
                    String dn = principalIterator.next().getName();
                    this.log.debug("Distinguished name " + dn);
                    response = this.performAuthentication(DN, new String(Base64.encode((byte[])dn.getBytes())), serviceString, operationName);
                    this.log.debug("Response = " + response);
                }
            }
        }
        return response;
    }

    private String performAuthentication(String type, String value, String serviceString, String instance) {
        if (serviceString == null || instance == null) {
            this.log.error("Unable to find service string or operation name");
            return null;
        }
        this.log.debug("Asking the cache...");
        String cacheString = type + value + serviceString + instance;
        this.log.debug("Cache string " + cacheString);
        String response = SOA3EhcacheWrapper.getInstance().get(cacheString);
        if (response == null) {
            this.log.debug("Response null, asking SOA3");
            response = this.askSoa3(type, value, serviceString, instance);
            if (response != null) {
                this.log.debug("Response found populating the cache");
                SOA3EhcacheWrapper.getInstance().put(cacheString, response);
                this.log.debug("Cache populated");
            } else {
                this.log.debug("No response from SOA3");
            }
        } else {
            this.log.debug("Response found in the cache");
        }
        this.log.debug("Response = " + response);
        return response;
    }

    private String askSoa3(String type, String value, String serviceString, String instance) {
        this.log.debug("Sending authentication message to SOA3");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", type + " " + value);
        headers.put("Servicestring", serviceString);
        headers.put("Serviceinstance", instance);
        String response = RestManager.getInstance(this.getSoa3Endpoint()).sendMessage("access", headers, null, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        this.log.debug("Authentication response = " + response);
        return response;
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    private String getSoa3Endpoint() {
        this.log.debug("Loading soa3 endpoint for the current operation and service");
        String endpoint = ConfigurationManagerFactory.getConfigurationManager().getServerUrl(this.serviceName);
        if (endpoint == null) {
            endpoint = this.defaultSoa3Endpoint;
        }
        this.log.debug("Actual endpoint " + endpoint);
        return endpoint;
    }
}

