/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.engine;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String soa3Endpoint;
    private Client client;
    private static Map<String, RestManager> instances = new HashMap<String, RestManager>();

    public static RestManager getInstance(String soa3Endpoint) {
        RestManager currentInstance = instances.get(soa3Endpoint);
        if (currentInstance == null) {
            currentInstance = new RestManager(soa3Endpoint);
            instances.put(soa3Endpoint, currentInstance);
        }
        return currentInstance;
    }

    private RestManager(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
        this.client = this.generateClient();
    }

    private Client generateClient() {
        this.logger.debug("creating client...");
        DefaultClientConfig config = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)config);
        this.logger.debug("Client created");
        return client;
    }

    private WebResource generateWebResource(Client client, String completeUrl) {
        this.logger.debug("creating a web resource...");
        WebResource resource = client.resource(completeUrl);
        this.logger.debug("Web resource created");
        return resource;
    }

    private WebResource.Builder getRequest(WebResource resource, MediaType acceptMediaType, MediaType mediaType) {
        this.logger.debug("setting JSon accept header...");
        WebResource.Builder request = (WebResource.Builder)resource.accept(new MediaType[]{acceptMediaType}).type(mediaType);
        this.logger.debug("Accept header set");
        return request;
    }

    public synchronized String sendMessage(String path, Map<String, String> headers, String body, MediaType mediaType, MediaType acceptMediaType) {
        this.logger.debug("Authentication service");
        String completeUrl = this.soa3Endpoint + "/" + path;
        WebResource authenticationResource = this.generateWebResource(this.client, completeUrl);
        WebResource.Builder authenticationBuilder = this.getRequest(authenticationResource, acceptMediaType, mediaType);
        this.logger.debug("Authentication web resource OK");
        for (String headerName : headers.keySet()) {
            String headerValue = headers.get(headerName);
            this.logger.debug("Adding header " + headerName + " value " + headerValue);
            authenticationBuilder = (WebResource.Builder)authenticationBuilder.header(headerName, (Object)headerValue);
            this.logger.debug("Header added");
        }
        this.logger.debug("Authentication builder OK");
        ClientResponse response = (ClientResponse)authenticationBuilder.get(ClientResponse.class);
        this.logger.debug("Response " + response);
        int status = response.getStatus();
        this.logger.debug("Status = " + status);
        String stringResponse = null;
        if (status >= 200 && status < 300) {
            stringResponse = (String)response.getEntity(String.class);
            this.logger.debug("Response = " + stringResponse);
        } else {
            this.logger.debug("Invalid response");
        }
        return stringResponse;
    }

    public static void main(String[] args) {
        RestManager manager = new RestManager("http://192.168.125.249:8080/soa3Service");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "BASIC dGVzdDpwYXNzd29yZA==");
        manager.sendMessage("access", header, null, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
    }
}

