/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.role.service;

import it.eng.rdlab.um.exceptions.RoleRetrievalException;
import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.ldap.role.bean.LdapRoleModel;
import it.eng.rdlab.um.ldap.role.bean.LdapRoleModelWrapper;
import it.eng.rdlab.um.ldap.role.service.LdapRoleCollectionManager;
import it.eng.rdlab.um.ldap.role.service.LdapRoleModelGenerator;
import it.eng.rdlab.um.ldap.service.exceptions.LdapManagerException;
import it.eng.rdlab.um.role.beans.RoleModel;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapRoleManager
extends LdapRoleCollectionManager {
    private Log log = LogFactory.getLog(this.getClass());

    public LdapRoleManager(String baseDn) throws NamingException {
        super(baseDn);
    }

    public boolean createRole(RoleModel roleModel) throws UserManagementSystemException {
        this.log.debug((Object)("Creating role with dn " + roleModel.getRoleId()));
        boolean response = false;
        try {
            response = this.ldapManager.createDataElement(new LdapRoleModelWrapper(roleModel));
        }
        catch (LdapManagerException e) {
            throw new UserManagementSystemException("unable to create the role", (Exception)e);
        }
        this.log.debug((Object)("Operation completed with response " + response));
        return response;
    }

    public RoleModel getRole(String roleId) throws UserManagementSystemException, RoleRetrievalException {
        this.log.debug((Object)("Getting role with dn " + roleId));
        try {
            return (LdapRoleModel)this.generateRole(roleId, new LdapRoleModelGenerator());
        }
        catch (LdapManagerException e) {
            this.log.error((Object)"Unable to contact the Ldap server", (Throwable)e);
            throw new RoleRetrievalException("Unable to contact the Ldap server", (Exception)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Generic LDAP error", (Throwable)e);
            throw new UserManagementSystemException("Unable to contact the Ldap server", e);
        }
    }

    public boolean updateRole(RoleModel roleModel) throws UserManagementSystemException, RoleRetrievalException {
        this.log.debug((Object)"Updating role");
        String roleDn = roleModel.getRoleId();
        RoleModel oldModel = this.getRole(roleDn);
        if (oldModel == null) {
            this.log.error((Object)"No role found");
            return false;
        }
        this.log.debug((Object)"Performing update operation...");
        boolean response = false;
        try {
            response = this.ldapManager.updateData(new LdapRoleModelWrapper(oldModel), new LdapRoleModelWrapper(roleModel));
            this.log.debug((Object)("Operation completed with response " + response));
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"Operation not completed", (Throwable)e);
            throw new UserManagementSystemException("Operation not completed", e);
        }
    }

    public List<RoleModel> listRoles() throws RoleRetrievalException {
        this.log.debug((Object)"Generic search");
        LdapRoleModel dummyFilter = new LdapRoleModel();
        dummyFilter.setRoleId(this.baseDn);
        return this.listRoles(dummyFilter);
    }

    public List<RoleModel> listRoles(RoleModel filter) throws RoleRetrievalException {
        this.log.debug((Object)"Filtered search");
        if (filter.getRoleId() == null || filter.getRoleId().length() == 0) {
            filter.setRoleId(this.baseDn);
        }
        return this.internalListRoles(new LdapRoleModelWrapper(filter), new LdapRoleModelGenerator());
    }
}

