/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.crossoperations;

import it.eng.rdlab.um.crossoperations.GroupRoleOperations;
import it.eng.rdlab.um.exceptions.GroupRetrievalException;
import it.eng.rdlab.um.exceptions.RoleRetrievalException;
import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.group.beans.GroupModel;
import it.eng.rdlab.um.ldap.group.bean.LdapGroupModel;
import it.eng.rdlab.um.ldap.group.service.LdapGroupManager;
import it.eng.rdlab.um.ldap.role.bean.LdapRoleModel;
import it.eng.rdlab.um.ldap.role.service.LdapRoleManager;
import it.eng.rdlab.um.role.beans.RoleModel;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapGroupRoleOperations
implements GroupRoleOperations {
    private Log log;
    private LdapGroupManager groupManager;
    private LdapRoleManager roleManager;

    public LdapGroupRoleOperations(LdapGroupManager groupManager, LdapRoleManager roleManager) throws ConfigurationException {
        if (groupManager == null || roleManager == null) {
            throw new ConfigurationException("At least one of the default managers is null");
        }
        this.groupManager = groupManager;
        this.roleManager = roleManager;
        this.log = LogFactory.getLog(this.getClass());
    }

    public void close() {
        this.groupManager.close();
        this.roleManager.close();
    }

    public List<RoleModel> listRolesByGroup(String groupId) throws RoleRetrievalException, GroupRetrievalException {
        this.log.debug((Object)("Listing all roles that contains the group " + groupId));
        LdapRoleModel filter = new LdapRoleModel();
        filter.addRoleOccupantDN(groupId);
        List<RoleModel> roleModels = this.roleManager.listRoles(filter);
        this.log.debug((Object)("response size = " + roleModels.size()));
        return roleModels;
    }

    public void assignRoleToGroup(String roleId, String groupId) throws UserManagementSystemException, GroupRetrievalException, RoleRetrievalException {
        this.log.debug((Object)"Assign role to group");
        this.log.debug((Object)"Forcing to find the group in order to verify if exists");
        this.groupManager.getGroup(groupId);
        this.log.debug((Object)"Group exists");
        LdapRoleModel roleModel = (LdapRoleModel)this.roleManager.getRole(roleId);
        LdapGroupModel groupModel = (LdapGroupModel)this.groupManager.getGroup(groupId);
        if (roleModel == null) {
            this.log.error((Object)("Role " + roleId + " not found"));
            throw new RoleRetrievalException("Role " + roleId + " not found");
        }
        if (groupModel == null) {
            this.log.error((Object)("Group " + groupId + " not found"));
            throw new GroupRetrievalException("Group " + groupId + " not found");
        }
        roleModel.addRoleOccupantDN(groupId);
        this.roleManager.updateRole(roleModel);
        groupModel.setRole(roleId);
        this.groupManager.updateGroup(groupModel);
    }

    public void dismissRoleFromGroup(String roleId, String groupId) throws UserManagementSystemException, GroupRetrievalException, RoleRetrievalException {
        this.log.debug((Object)"Removing group from role");
        LdapRoleModel roleModel = (LdapRoleModel)this.roleManager.getRole(roleId);
        boolean response = false;
        if (roleModel.getRoleOccupantDNS().remove(groupId)) {
            response = this.roleManager.updateRole(roleModel);
        } else {
            this.log.warn((Object)("Element " + groupId + " not found"));
            response = true;
        }
        this.log.debug((Object)("Operation complete with response " + response));
    }

    public List<GroupModel> listGroupsByRole(String roleId) throws UserManagementSystemException, RoleRetrievalException, GroupRetrievalException {
        this.log.debug((Object)("Listing all the groups contained in the role " + roleId));
        LdapRoleModel roleModel = (LdapRoleModel)this.roleManager.getRole(roleId);
        List<String> groupIds = roleModel.getRoleOccupantDNS();
        ArrayList<GroupModel> response = new ArrayList<GroupModel>();
        for (String dn : groupIds) {
            this.log.debug((Object)("Getting group with DN " + dn));
            try {
                GroupModel groupModel = this.groupManager.getGroup(dn);
                if (groupModel == null) {
                    this.log.error((Object)("Group with dn " + dn + " not found!"));
                    continue;
                }
                response.add(groupModel);
            }
            catch (Exception e) {
                this.log.warn((Object)("Group " + dn + " not found"));
            }
        }
        this.log.debug((Object)("Response size = " + response.size()));
        return response;
    }
}

