/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.group.service;

import it.eng.rdlab.um.exceptions.GroupRetrievalException;
import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.group.beans.GroupModel;
import it.eng.rdlab.um.ldap.group.bean.LdapOrganizationModel;
import it.eng.rdlab.um.ldap.group.bean.LdapOrganizationModelWrapper;
import it.eng.rdlab.um.ldap.group.service.LdapCollectionManager;
import it.eng.rdlab.um.ldap.group.service.LdapGroupManager;
import it.eng.rdlab.um.ldap.group.service.LdapOrganizationModelGenerator;
import it.eng.rdlab.um.ldap.service.LdapManager;
import it.eng.rdlab.um.ldap.service.exceptions.LdapManagerException;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapOrganizationManager
extends LdapCollectionManager {
    private Log log = LogFactory.getLog(this.getClass());

    public LdapOrganizationManager(String baseDn) throws NamingException {
        super(baseDn);
        this.ldapManager = LdapManager.getInstance();
        this.baseDn = baseDn != null ? baseDn : "";
    }

    public boolean createGroup(GroupModel groupModel) throws UserManagementSystemException {
        this.log.debug((Object)("Creating group with dn " + groupModel.getGroupId()));
        boolean response = false;
        try {
            response = this.ldapManager.createDataElement(new LdapOrganizationModelWrapper(groupModel));
        }
        catch (LdapManagerException e) {
            throw new UserManagementSystemException("unable to create the user", (Exception)e);
        }
        this.log.debug((Object)("Operation completed with response " + response));
        return response;
    }

    public GroupModel getGroup(String groupId) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)("Getting group with dn " + groupId));
        try {
            return (GroupModel)this.generateGroup(groupId, new LdapOrganizationModelGenerator());
        }
        catch (LdapManagerException e) {
            this.log.error((Object)"Unable to contact the Ldap server", (Throwable)e);
            throw new GroupRetrievalException("Unable to contact the Ldap server", (Exception)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Generic LDAP error", (Throwable)e);
            throw new UserManagementSystemException("Unable to contact the Ldap server", e);
        }
    }

    public boolean updateGroup(GroupModel groupModel) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)"Updating user");
        String groupDn = groupModel.getGroupId();
        GroupModel oldModel = this.getGroup(groupDn);
        if (oldModel == null) {
            this.log.error((Object)"No user found");
            return false;
        }
        this.log.debug((Object)"Performing update operation...");
        boolean response = false;
        try {
            response = this.ldapManager.updateData(new LdapOrganizationModelWrapper(oldModel), new LdapOrganizationModelWrapper(groupModel));
            this.log.debug((Object)("Operation completed with response " + response));
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"Operation not completed", (Throwable)e);
            throw new UserManagementSystemException("Operation not completed", e);
        }
    }

    public List<GroupModel> listGroups() throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)"Generic search");
        LdapOrganizationModel dummyFilter = new LdapOrganizationModel();
        dummyFilter.setGroupId(this.baseDn);
        return this.listGroups(dummyFilter);
    }

    public List<GroupModel> listGroups(GroupModel filter) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)"Filtered search");
        if (filter.getGroupId() == null || filter.getGroupId().length() == 0) {
            filter.setGroupId(this.baseDn);
        }
        return this.internalListGroups(new LdapOrganizationModelWrapper(filter), new LdapOrganizationModelGenerator());
    }

    public List<GroupModel> listSubGroupsByGroup(String groupId) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)("Listing subgroups for organization " + groupId));
        try {
            this.log.debug((Object)"Using default group manager to find subgroups");
            LdapGroupManager groupManager = new LdapGroupManager(groupId);
            return groupManager.listGroups();
        }
        catch (NamingException e) {
            this.log.error((Object)"Generic LDAP error", (Throwable)e);
            throw new UserManagementSystemException("Unable to contact the Ldap server", (Exception)e);
        }
    }

    public boolean createSubGroup(String parentGroupId, GroupModel groupModel) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)"Creating new Sub Group...");
        this.log.debug((Object)("Listing subgroups for organization " + parentGroupId));
        try {
            this.log.debug((Object)"Using default group manager to find subgroups");
            LdapGroupManager groupManager = new LdapGroupManager(parentGroupId);
            return groupManager.createGroup(groupModel);
        }
        catch (NamingException e) {
            this.log.error((Object)"Generic LDAP error", (Throwable)e);
            throw new UserManagementSystemException("Unable to contact the Ldap server", (Exception)e);
        }
    }
}

