/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.validators;

import it.eng.rdlab.um.ldap.Utils;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapRoleValidator {
    public static boolean validate(String dn, List<String> objectClassesList, Map<String, String> attributeMap, List<String> roleOccupantList) {
        Log log = LogFactory.getLog(LdapRoleValidator.class);
        log.debug((Object)"Checking object classes list...");
        if (dn == null || Utils.parseDN(dn) == null) {
            log.debug((Object)"Distinguished name not valid");
            return false;
        }
        if (objectClassesList == null || objectClassesList.size() == 0 || !objectClassesList.contains("organizationalRole")) {
            log.debug((Object)"Invalid object class list");
            return false;
        }
        log.debug((Object)"Checking user mandatory parameters dn, cn and sn");
        log.debug((Object)("DN = " + dn));
        boolean cn = attributeMap.get("cn") != null;
        log.debug((Object)("Common name ok = " + cn));
        return cn && roleOccupantList != null && roleOccupantList.size() > 0;
    }
}

