/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.user.bean;

import it.eng.rdlab.um.beans.GenericModel;
import it.eng.rdlab.um.ldap.LdapAbstractModelWrapper;
import it.eng.rdlab.um.ldap.validators.LdapUserValidator;
import it.eng.rdlab.um.user.beans.UserModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapUserModelWrapper
extends LdapAbstractModelWrapper {
    private Log log = LogFactory.getLog(this.getClass());

    public LdapUserModelWrapper(UserModel userModel) {
        super((GenericModel)userModel);
        this.initModel(userModel);
    }

    private void initModel(UserModel userModel) {
        this.log.debug((Object)"Loading uid");
        this.attributeMap.put("uid", userModel.getUserId());
        this.log.debug((Object)"Loading password");
        char[] password = userModel.getPassword();
        if (password != null && (password.length > 1 || password[0] != ' ')) {
            String passwordString = new String(password);
            if (!passwordString.equals("ENCRYPTED_PASSWORD")) {
                this.attributeMap.put("userPassword", passwordString);
            } else {
                this.log.debug((Object)"Encrypted_password label_found");
            }
        }
        this.log.debug((Object)"Loading dn");
        this.dn = userModel.getFullname();
    }

    @Override
    public boolean validateData() {
        return LdapUserValidator.validate(this.dn, this.objectClasses, this.attributeMap);
    }
}

