/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.service;

import it.eng.rdlab.um.ldap.LdapDataModelWrapper;
import it.eng.rdlab.um.ldap.service.LdapDataModelComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapGenericDataModelComparator
implements LdapDataModelComparator {
    private Log log = LogFactory.getLog(LdapGenericDataModelComparator.class);

    @Override
    public List<ModificationItem> compare(LdapDataModelWrapper dataModel1, LdapDataModelWrapper dataModel2) {
        ArrayList<ModificationItem> response = new ArrayList<ModificationItem>();
        this.log.debug((Object)"Generating single value attributes maps...");
        Map<String, String> singleValueAttributes1 = dataModel1.getAttributeMap();
        Map<String, String> singleValueAttributes2 = dataModel2.getAttributeMap();
        this.log.debug((Object)"Maps generated");
        this.compareSingleValueAttributes(response, singleValueAttributes1, singleValueAttributes2);
        this.log.debug((Object)"Generating multi value attributes maps...");
        Map<String, List<String>> multiValueAttributes1 = dataModel1.getListAttributeMap();
        Map<String, List<String>> multiValueAttributes2 = dataModel2.getListAttributeMap();
        this.log.debug((Object)"Maps generated");
        this.compareMultiValueAttributes(response, multiValueAttributes1, multiValueAttributes2);
        return response;
    }

    protected void compareSingleValueAttributes(List<ModificationItem> response, Map<String, String> attributes1, Map<String, String> attributes2) {
        this.log.debug((Object)"Comparing single value attributes");
        Iterator<String> keys1 = attributes1.keySet().iterator();
        this.log.debug((Object)"Checking modifications");
        while (keys1.hasNext()) {
            String key = keys1.next();
            this.log.debug((Object)("Key 1 = " + key));
            String value2 = attributes2.get(key);
            if (value2 == null) {
                this.log.debug((Object)(key + " to be removed"));
                response.add(new ModificationItem(3, new BasicAttribute(key)));
                continue;
            }
            if (attributes1.get(key).equals(value2)) continue;
            this.log.debug((Object)(key + " to be replaced with " + value2));
            response.add(new ModificationItem(2, new BasicAttribute(key, value2)));
        }
        this.log.debug((Object)"Check completed");
        Iterator<String> keys2 = attributes2.keySet().iterator();
        this.log.debug((Object)"Checking extra attributes...");
        while (keys2.hasNext()) {
            String key = keys2.next();
            this.log.debug((Object)("Key 2 = " + key));
            if (attributes1.get(key) != null) continue;
            this.log.debug((Object)("Attribute " + key + " to be added"));
            response.add(new ModificationItem(1, new BasicAttribute(key, attributes2.get(key))));
        }
        this.log.debug((Object)"Check completed");
    }

    protected void compareMultiValueAttributes(List<ModificationItem> response, Map<String, List<String>> attributes1, Map<String, List<String>> attributes2) {
        this.log.debug((Object)"Comparing multi value attributes");
        Iterator<String> keys1 = attributes1.keySet().iterator();
        this.log.debug((Object)"Checking modifications");
        while (keys1.hasNext()) {
            String key = keys1.next();
            this.log.debug((Object)("Key 1 = " + key));
            List<String> attributes2Values = attributes2.get(key);
            if (attributes2Values == null) {
                response.add(new ModificationItem(3, new BasicAttribute(key)));
                continue;
            }
            List<String> attributes1Values = attributes1.get(key);
            BasicAttribute basicAttribute = new BasicAttribute(key);
            boolean update = false;
            for (String valueString2 : attributes2Values) {
                if (!attributes1Values.contains(valueString2)) {
                    update = true;
                }
                basicAttribute.add(valueString2);
            }
            if (!update && attributes1Values.size() <= attributes2Values.size()) continue;
            response.add(new ModificationItem(2, basicAttribute));
        }
        this.log.debug((Object)"Check completed");
        Iterator<String> keys2 = attributes2.keySet().iterator();
        this.log.debug((Object)"Checking extra attributes...");
        while (keys2.hasNext()) {
            String key = keys2.next();
            this.log.debug((Object)("Key 2 = " + key));
            if (attributes1.get(key) != null) continue;
            this.log.debug((Object)("Attribute " + key + " to be added"));
            BasicAttribute basicAttribute = new BasicAttribute(key);
            List<String> values = attributes2.get(key);
            for (String value : values) {
                basicAttribute.add(value);
            }
            response.add(new ModificationItem(1, new BasicAttribute(key, basicAttribute)));
        }
        this.log.debug((Object)"Check completed");
    }
}

