/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.role.bean;

import it.eng.rdlab.um.ldap.LdapModelConstants;
import it.eng.rdlab.um.role.beans.RoleModel;
import java.util.ArrayList;
import java.util.List;

public class LdapRoleModel
extends RoleModel
implements LdapModelConstants {
    public static final String OBJECT_CLASS_ROLE = "organizationalRole";
    public static final String ROLE_OCCUPANT = "roleOccupant";
    public static final String ROLE_CN = "cn";
    public static final String DESCRIPTION = "description";

    public LdapRoleModel() {
        ArrayList<String> objectClasses = new ArrayList<String>();
        objectClasses.add("top");
        objectClasses.add(OBJECT_CLASS_ROLE);
        super.addObject("OBJECTCLASSES", objectClasses);
        super.addObject(ROLE_OCCUPANT, new ArrayList());
        this.setId("");
    }

    public LdapRoleModel(RoleModel roleModel) {
        super(roleModel);
    }

    public LdapRoleModel(String roleDN, String roleCN, String description, List<String> objectClasses) {
        super(roleDN, roleCN, description);
        if (objectClasses == null) {
            objectClasses = new ArrayList<String>();
            objectClasses.add("top");
            objectClasses.add(OBJECT_CLASS_ROLE);
            super.addObject("OBJECTCLASSES", objectClasses);
        } else {
            if (!objectClasses.contains("top")) {
                objectClasses.add("top");
            }
            if (!objectClasses.contains(OBJECT_CLASS_ROLE)) {
                this.addObjectClass(OBJECT_CLASS_ROLE);
            }
        }
        if (roleDN == null) {
            this.setId("");
        }
        if (roleCN == null) {
            this.setRoleName("");
        }
        super.addObject(ROLE_OCCUPANT, new ArrayList());
    }

    public void setDN(String roleDN) {
        super.setId(roleDN);
    }

    public String getDN() {
        return this.getId();
    }

    public List<String> getObjectClasses() {
        return (List)super.getObject("OBJECTCLASSES");
    }

    public void addObjectClass(String objectClassName) {
        ((List)super.getObject("OBJECTCLASSES")).add(objectClassName);
    }

    public void addRoleOccupantDN(String roleOccupantDN) {
        ((List)super.getObject(ROLE_OCCUPANT)).add(roleOccupantDN);
    }

    public List<String> getRoleOccupantDNS() {
        return (List)super.getObject(ROLE_OCCUPANT);
    }

    public void addExtraAttribute(String name, String value) {
        super.addObject(name, (Object)value);
    }
}

