/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.javaapi.impl.engine;

import it.eng.rdlab.soa3.pm.connector.beans.Status;
import it.eng.rdlab.soa3.pm.connector.interfaces.PolicyAdder;
import it.eng.rdlab.soa3.pm.connector.interfaces.PolicyDeleter;
import it.eng.rdlab.soa3.pm.connector.interfaces.PolicyReader;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.Attribute;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.ResponseBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.RuleBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.configuration.ConfigurationManagerBuilder;
import it.eng.rdlab.soa3.pm.connector.javaapi.engine.PolicyEngine;
import it.eng.rdlab.soa3.pm.connector.javaapi.impl.beans.AttributesManagementBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.impl.engine.PolicyReloader;
import it.eng.rdlab.soa3.pm.connector.javaapi.impl.factory.PolicyManagerFactory;
import it.eng.rdlab.soa3.pm.connector.javaapi.impl.utils.AttributeLoader;
import it.eng.rdlab.soa3.pm.connector.javaapi.impl.utils.PolicyRuleBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.impl.utils.Utils;
import it.eng.rdlab.soa3.pm.xacml.XACMLManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensaml.xacml.policy.ActionMatchType;
import org.opensaml.xacml.policy.ActionType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.policy.ResourceMatchType;
import org.opensaml.xacml.policy.ResourceType;
import org.opensaml.xacml.policy.RuleType;
import org.opensaml.xacml.policy.SubjectMatchType;
import org.opensaml.xacml.policy.SubjectType;
import org.opensaml.xacml.policy.TargetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEngineImpl
implements PolicyEngine {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PolicyReloader reloader = new PolicyReloader(ConfigurationManagerBuilder.getConfigurationManager().getPolicyLoaderUrl());

    public ResponseBean createRule(RuleBean ruleBean) {
        this.logger.debug("Creating policy...");
        PolicyAdder adder = PolicyManagerFactory.getPolicyAdder();
        AttributesManagementBean attributesBean = Utils.generateAttributeManagerBean(ruleBean);
        Status addRuleResponse = adder.addNewRule(null, attributesBean.getSubjectAttributes(), attributesBean.getActionId(), attributesBean.getResourceId(), ruleBean.isPermitted(), null, attributesBean.isMoveAfter());
        this.logger.debug("Response " + addRuleResponse);
        if (addRuleResponse.getStatus() == 0 && addRuleResponse.getResult() == 0) {
            this.logger.debug("Rule created");
            String ruleID = addRuleResponse.getInfo();
            this.logger.debug("Rule id = " + ruleID);
            return this.addExtraParameters(adder, ruleID, ruleBean.getDateRange(), ruleBean.getTimeRange());
        }
        this.logger.debug("Rule not created");
        return new ResponseBean(-2, null);
    }

    public RuleBean getRule(String ruleId) {
        this.logger.debug("Reading policy...");
        this.logger.debug("Rule ID " + ruleId);
        PolicyReader reader = PolicyManagerFactory.getPolicyReader();
        PolicyRuleBean policyRuleBean = Utils.findPolicyContainingRule(reader, ruleId);
        if (policyRuleBean != null) {
            this.logger.debug("Rule found");
            RuleBean bean = Utils.createRuleBean(policyRuleBean.getPolicySetType(), policyRuleBean.getPolicyType(), policyRuleBean.getRuleType());
            this.logger.debug("Response bean generated");
            return bean;
        }
        this.logger.debug("Rule not found");
        return null;
    }

    public ResponseBean updateRule(String ruleId, RuleBean ruleBean) {
        this.logger.debug("Update rule");
        this.logger.debug("deleting old rule...");
        boolean deleteRuleResponse = this.deleteRule(ruleId, false);
        if (deleteRuleResponse) {
            this.logger.debug("Rule deleted: adding updated rule");
            return this.createRule(ruleBean);
        }
        this.logger.debug("Rule not found");
        return new ResponseBean(-3, null);
    }

    public boolean deleteRule(String ruleId) {
        return this.deleteRule(ruleId, true);
    }

    public boolean deleteRule(String ruleId, boolean reloadPolicies) {
        this.logger.debug("Deleting policy...");
        this.logger.debug("For rule id " + ruleId);
        if (ruleId == null) {
            this.logger.error("Rule id null");
            return false;
        }
        PolicyDeleter deleter = PolicyManagerFactory.getPolicyDeleter();
        Status policyDeleterResponse = deleter.deleteRule(null, ruleId);
        if (policyDeleterResponse.getStatus() == 0 && policyDeleterResponse.getResult() == 0) {
            this.logger.debug("Policy deleted");
            if (reloadPolicies) {
                this.reloadPolicies();
            }
            return true;
        }
        this.logger.debug("Policy not deleted");
        return false;
    }

    public List<RuleBean> listAllRules() {
        this.logger.debug("Retrieving all rules...");
        List<RuleBean> response = this.listRules(false, null);
        this.logger.debug("Operation completed");
        return response;
    }

    public List<RuleBean> listRulesBySubjects(List<Attribute> subjects) {
        this.logger.debug("List rules by subject");
        List<RuleBean> response = this.listRules(true, subjects);
        this.logger.debug("Rules loaded");
        return response;
    }

    public List<RuleBean> listRulesByAction(String action) {
        this.logger.debug("List rules by action");
        this.logger.debug("Action " + action);
        PolicyReader reader = PolicyManagerFactory.getPolicyReader();
        PolicyType[] policyTypes = this.loadPolicies(reader);
        ArrayList<RuleBean> response = new ArrayList<RuleBean>();
        if (policyTypes != null) {
            this.logger.debug("Policies loaded");
            int policyIndex = 0;
            PolicySetType[] policySets = this.loadPolicySets(reader);
            if (policySets != null) {
                while (policyIndex < policyTypes.length) {
                    try {
                        this.logger.debug("Policy " + policyTypes[policyIndex].getPolicyId());
                        TargetType target = policyTypes[policyIndex].getTarget();
                        List actionList = target.getActions().getActions();
                        for (ActionType at : actionList) {
                            try {
                                String actionValue = ((ActionMatchType)at.getActionMatches().get(0)).getAttributeValue().getValue();
                                this.logger.debug("Action value " + actionValue);
                                if (!action.matches(actionValue)) continue;
                                this.logger.debug("Action found");
                                this.logger.debug("Finding policy set");
                                PolicySetType policySet = Utils.findPolicySetContainingPolicy(policySets, policyTypes[policyIndex].getPolicyId());
                                if (policySet != null) {
                                    this.logger.debug("Policy set found");
                                    this.addRuleTypes(response, policyTypes[policyIndex], policySet);
                                    continue;
                                }
                                this.logger.error("Policy set not found: inconsistent policy list");
                            }
                            catch (Exception e) {
                                this.logger.error("Unable to find a valid resource value", (Throwable)e);
                            }
                        }
                        ++policyIndex;
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Invalid policy");
                    }
                }
            } else {
                this.logger.error("Policy sets not found: inconsistent policy list");
            }
        } else {
            this.logger.error("Unable to load policies");
            return null;
        }
        return response;
    }

    public List<RuleBean> listRulesByResource(String resource) {
        this.logger.debug("List rules by resource");
        this.logger.debug("Resource " + resource);
        PolicyReader reader = PolicyManagerFactory.getPolicyReader();
        PolicySetType[] policySetTypes = this.loadPolicySets(reader);
        ArrayList<RuleBean> response = new ArrayList<RuleBean>();
        if (policySetTypes != null) {
            try {
                this.logger.debug("Policy sets loaded");
                PolicySetType policySet = this.searchPolicySetByResource(policySetTypes, resource);
                if (policySet != null) {
                    List<PolicyType> policyTypeList = Utils.getPoliciesFromPolicySet(reader, policySet);
                    for (PolicyType policyType : policyTypeList) {
                        this.addRuleTypes(response, policyType, policySet);
                    }
                }
                this.logger.debug("No rules associated with resource " + resource);
            }
            catch (RuntimeException e) {
                this.logger.error("Unable to load rules: invalid document", (Throwable)e);
                return null;
            }
        } else {
            this.logger.error("Unable to load policy set");
            return null;
        }
        this.logger.debug("Found " + response.size() + " rules");
        return response;
    }

    public List<RuleBean> listRules() {
        this.logger.debug("List all the rules");
        List<RuleBean> response = this.listRules(false, null);
        this.logger.debug("Rules loaded");
        return response;
    }

    public boolean deleteAll() {
        this.logger.debug("Deleting the repository...");
        PolicyDeleter deleter = PolicyManagerFactory.getPolicyDeleter();
        Status eraseRepository = deleter.clear();
        if (eraseRepository.getStatus() == 0 && eraseRepository.getResult() == 0) {
            this.logger.debug("Repository deleted");
            this.reloadPolicies();
            return true;
        }
        this.logger.debug("Repository not deleted");
        return false;
    }

    public String getRuleId(RuleBean ruleBean) {
        this.logger.debug("Getting rule id of the rule with ");
        this.logger.debug("Attributes " + ruleBean.getAttributes());
        this.logger.debug("Action " + ruleBean.getAction());
        this.logger.debug("Resource " + ruleBean.getResource());
        String response = null;
        if (ruleBean.getAttributes() != null && ruleBean.getAttributes().size() > 0 && ruleBean.getAction() != null && ruleBean.getResource() != null) {
            this.logger.debug("loading rule...");
            List<RuleBean> rulesByResource = this.listRulesByResource(ruleBean.getResource());
            if (rulesByResource != null && rulesByResource.size() > 0) {
                this.logger.debug("Applying action filter...");
                ArrayList<RuleBean> rulesByAction = new ArrayList<RuleBean>();
                for (RuleBean bean : rulesByResource) {
                    if (!ruleBean.getAction().equals(bean.getAction())) continue;
                    this.logger.debug("Found valid rule");
                    rulesByAction.add(bean);
                }
                this.logger.debug("Action filter applied");
                Iterator ruleBeanIterator = rulesByAction.iterator();
                this.logger.debug("Applying attributes filter...");
                while (ruleBeanIterator.hasNext() && response == null) {
                    RuleBean bean;
                    bean = (RuleBean)ruleBeanIterator.next();
                    if (!this.checkRuleBeanAttributes(bean, ruleBean.getAttributes())) continue;
                    this.logger.debug("Rule id found " + bean.getRuleId());
                    this.logger.debug("Setting rule id");
                    response = bean.getRuleId();
                }
            }
        } else {
            this.logger.error("Missing parameters");
        }
        return response;
    }

    private List<RuleBean> listRules(boolean enableFilter, List<Attribute> subjects) {
        this.logger.debug("Loading rules");
        this.logger.debug("Filter " + enableFilter);
        PolicyReader reader = PolicyManagerFactory.getPolicyReader();
        PolicyType[] policyTypes = this.loadPolicies(reader);
        ArrayList<RuleBean> response = new ArrayList<RuleBean>();
        if (policyTypes != null) {
            this.logger.debug("Policies loaded");
            PolicySetType[] policySetTypes = this.loadPolicySets(reader);
            if (policySetTypes != null) {
                for (int policyIndex = 0; policyIndex < policyTypes.length; ++policyIndex) {
                    try {
                        this.logger.debug("Policy " + policyTypes[policyIndex].getPolicyId());
                        this.logger.debug("Loading rules from policy " + policyTypes[policyIndex].getPolicyId());
                        List ruleTypeList = policyTypes[policyIndex].getRules();
                        for (RuleType ruleType : ruleTypeList) {
                            if (enableFilter && !this.checkAttributes(ruleType, subjects)) continue;
                            this.logger.debug("Converting rule " + ruleType.getRuleId());
                            this.logger.debug("Loading policy set");
                            PolicySetType policySet = Utils.findPolicySetContainingPolicy(policySetTypes, policyTypes[policyIndex].getPolicyId());
                            if (policySet != null) {
                                response.add(Utils.createRuleBean(policySet, policyTypes[policyIndex], ruleType));
                                this.logger.debug("Conversion completed");
                                continue;
                            }
                            this.logger.error("Unable to find the policy set: inconsistent policies list");
                        }
                        this.logger.debug("Operation completed");
                        continue;
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Invalid policy", (Throwable)e);
                    }
                }
            } else {
                this.logger.error("Unable to find the policy sets: inconsistent policies list");
            }
        } else {
            this.logger.error("Unable to load policies");
            return null;
        }
        return response;
    }

    private boolean checkAttributes(RuleType ruleType, List<Attribute> attributes) {
        this.logger.debug("Check attributes...");
        boolean result = false;
        if (attributes == null || attributes.size() == 0) {
            this.logger.debug("No attributes found");
            result = true;
        } else {
            try {
                this.logger.debug("Checking attributes");
                TargetType targetType = ruleType.getTarget();
                List subjectTypeList = targetType.getSubjects().getSubjects();
                this.logger.debug("Attributes loaded, checking...");
                Iterator subjectTypeIterator = subjectTypeList.iterator();
                while (subjectTypeIterator.hasNext() && !result) {
                    this.logger.debug("Checking subject");
                    SubjectType subjectType = (SubjectType)subjectTypeIterator.next();
                    ArrayList<Attribute> localList = new ArrayList<Attribute>(attributes);
                    List matches = subjectType.getSubjectMatches();
                    Iterator matchesIterator = matches.iterator();
                    while (matchesIterator.hasNext() && !localList.isEmpty()) {
                        SubjectMatchType matchType = (SubjectMatchType)matchesIterator.next();
                        String id = matchType.getSubjectAttributeDesignator().getAttributeId();
                        this.logger.debug("Attribute id = " + id);
                        String value = matchType.getAttributeValue().getValue();
                        this.logger.debug("Attribute value = " + value);
                        Iterator attributesIterator = localList.iterator();
                        boolean found = false;
                        while (attributesIterator.hasNext() && !found) {
                            Attribute attribute = (Attribute)attributesIterator.next();
                            String attributeKey = AttributeLoader.getInstance().getAttribute(attribute.getId());
                            String attributeValue = attribute.getValue();
                            this.logger.debug("To be checked against");
                            this.logger.debug("ID " + attributeKey);
                            this.logger.debug("Value " + attributeValue);
                            if (!attributeKey.equals(id) || !value.matches(attributeValue)) continue;
                            found = true;
                            this.logger.debug("Attributes matches");
                            localList.remove(attribute);
                            this.logger.debug("Attribute removed from local map");
                        }
                    }
                    if (!localList.isEmpty()) continue;
                    this.logger.debug("Rule found");
                    result = true;
                }
            }
            catch (RuntimeException e) {
                this.logger.debug("Invalid xacml rule", (Throwable)e);
            }
        }
        this.logger.debug("Result " + result);
        return result;
    }

    private void addRuleTypes(List<RuleBean> ruleBeanList, PolicyType policyType, PolicySetType policySetType) {
        this.logger.debug("Loading rules from policy " + policyType.getPolicyId());
        List ruleTypeList = policyType.getRules();
        for (RuleType ruleType : ruleTypeList) {
            this.logger.debug("Converting rule " + ruleType.getRuleId());
            ruleBeanList.add(Utils.createRuleBean(policySetType, policyType, ruleType));
            this.logger.debug("Conversion completed");
        }
        this.logger.debug("Operation completed");
    }

    private PolicySetType searchPolicySetByResource(PolicySetType[] policySetTypes, String resource) {
        this.logger.debug("Scanning policy sets");
        PolicySetType policySet = null;
        this.logger.debug("Policy sets list size " + policySetTypes.length);
        for (int policySetIndex = 0; policySetIndex < policySetTypes.length && policySet == null; ++policySetIndex) {
            this.logger.debug("Policy set " + policySetTypes[policySetIndex].getPolicySetId() + " index " + policySetIndex);
            TargetType target = policySetTypes[policySetIndex].getTarget();
            if (target == null || target.getResources() == null || target.getResources().getResources() == null) continue;
            List resourceList = target.getResources().getResources();
            Iterator resourceListIterator = resourceList.iterator();
            while (resourceListIterator.hasNext() && policySet == null) {
                ResourceType rt = (ResourceType)resourceListIterator.next();
                try {
                    String resourceValue = ((ResourceMatchType)rt.getResourceMatches().get(0)).getAttributeValue().getValue();
                    this.logger.debug("Resource value " + resourceValue);
                    if (!resource.matches(resourceValue)) continue;
                    this.logger.debug("Resource found");
                    policySet = policySetTypes[policySetIndex];
                }
                catch (Exception e) {
                    this.logger.error("Unable to find a valid resource value", (Throwable)e);
                }
            }
        }
        return policySet;
    }

    private void setTimeParametersInRuleType(RuleType ruleType, String dateRange, String timeRange) {
        this.logger.debug("Setting time parameters in the policy");
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        if (dateRange != null && timeRange != null) {
            this.logger.debug("Adding date-time parameter...");
            Utils.setDateParameters(dateRange, startCalendar, endCalendar);
            Utils.setTimeParameters(timeRange, startCalendar, endCalendar);
            this.logger.debug("Date-time parameters added");
            ruleType.setCondition(XACMLManager.generateComplexDateTimeComparison((Date)endCalendar.getTime(), (Date)startCalendar.getTime(), (boolean)true, (boolean)true));
            this.logger.debug("Date-time parameter added");
        } else if (dateRange != null) {
            this.logger.debug("Adding date parameter...");
            Utils.setDateParameters(dateRange, startCalendar, endCalendar);
            startCalendar.set(11, 0);
            startCalendar.set(12, 0);
            startCalendar.set(13, 0);
            endCalendar.set(11, 0);
            endCalendar.set(12, 0);
            endCalendar.set(13, 0);
            this.logger.debug("Date parameters added");
            ruleType.setCondition(XACMLManager.generateComplexDateComparison((Date)endCalendar.getTime(), (Date)startCalendar.getTime(), (boolean)true, (boolean)true));
            this.logger.debug("Date parameter added");
        } else if (timeRange != null) {
            this.logger.debug("Adding time parameter...");
            Utils.setTimeParameters(timeRange, startCalendar, endCalendar);
            this.logger.debug("Time parameters added");
            ruleType.setCondition(XACMLManager.generateComplexTimeComparison((Date)endCalendar.getTime(), (Date)startCalendar.getTime(), (boolean)true, (boolean)true));
            this.logger.debug("Time parameter added");
        }
    }

    private boolean addTimeIntervals(PolicyAdder adder, String dateRange, String timeRange, PolicyType policyType, RuleType ruleType) {
        this.logger.debug("Checking time intervals ");
        this.logger.debug("Date Range " + dateRange);
        this.logger.debug("Time range " + timeRange);
        boolean response = false;
        this.logger.debug("Adding extra parameters");
        this.setTimeParametersInRuleType(ruleType, dateRange, timeRange);
        if (this.executeUpdate(adder, policyType)) {
            this.logger.debug("Extra parameters added");
            response = true;
        } else {
            this.logger.error("Unable to add the extra parameters: an error occourred in the update process");
        }
        return response;
    }

    private boolean executeUpdate(PolicyAdder adder, PolicyType policyType) {
        this.logger.debug("Executing update operation...");
        int version = Integer.parseInt(policyType.getVersion());
        System.out.println("DOM " + policyType.getDOM());
        Status response = adder.updateXACMLPolicy(null, version, XACMLManager.policy2Element((PolicyType)policyType));
        this.logger.debug("Operation executed");
        boolean result = response.getStatus() == 0 && response.getResult() == 0;
        this.logger.debug("Result " + result);
        return result;
    }

    private PolicySetType[] loadPolicySets(PolicyReader policyReader) {
        this.logger.debug("Loading all policy sets...");
        Status listPolicySetsResponse = policyReader.listPolicySets(null);
        PolicySetType[] policySetTypes = null;
        if (listPolicySetsResponse.getStatus() == 0 && listPolicySetsResponse.getResult() == 0) {
            this.logger.debug("Policy sets loaded");
            String policySetString = listPolicySetsResponse.getInfo();
            this.logger.debug("Policy Set " + policySetString);
            policySetTypes = XACMLManager.getPolicySetsFromString((String)policySetString);
        } else {
            this.logger.debug("Policy sets loaded");
        }
        return policySetTypes;
    }

    private PolicyType[] loadPolicies(PolicyReader policyReader) {
        this.logger.debug("Loading all policy sets...");
        Status listPoliciesResponse = policyReader.listPolicies(null);
        PolicyType[] policyTypes = null;
        if (listPoliciesResponse.getStatus() == 0 && listPoliciesResponse.getResult() == 0) {
            this.logger.debug("Policies loaded");
            String policyString = listPoliciesResponse.getInfo();
            this.logger.debug("Policy" + policyString);
            policyTypes = XACMLManager.getPolicesFromString((String)policyString);
        } else {
            this.logger.debug("Policy sets loaded");
        }
        return policyTypes;
    }

    private boolean checkRuleBeanAttributes(RuleBean ruleBean, Map<String, String> attributeMap) {
        this.logger.debug("Checking if the attributes are present in the rule bean");
        HashMap attributeBeanLocalMap = new HashMap(ruleBean.getAttributes());
        Iterator<String> keys = attributeMap.keySet().iterator();
        boolean equal = true;
        while (keys.hasNext() && equal) {
            String comparismKey = keys.next();
            String comparismValue = attributeMap.get(comparismKey);
            this.logger.debug("Checking key " + comparismKey + " value " + comparismValue);
            String value = (String)attributeBeanLocalMap.remove(comparismKey);
            this.logger.debug("Compared value " + value);
            if (value == null || !comparismValue.equals(value)) {
                this.logger.debug("Value not equal");
                equal = false;
                continue;
            }
            this.logger.debug("Value found");
        }
        boolean response = equal && attributeBeanLocalMap.size() == 0;
        this.logger.debug("Response " + response);
        return response;
    }

    private ResponseBean addExtraParameters(PolicyAdder adder, String ruleID, String dateRange, String timeRange) {
        if (!(dateRange != null && dateRange.trim().length() != 0 || timeRange != null && timeRange.trim().length() != 0)) {
            this.logger.debug("No extra parameters to be added");
            this.reloadPolicies();
        } else {
            this.logger.debug("Adding extra parameters");
            PolicyReader policyReader = PolicyManagerFactory.getPolicyReader();
            this.logger.debug("Reading policy containing created rule");
            PolicyRuleBean policyRuleBean = Utils.findPolicyContainingRule(policyReader, ruleID);
            if (policyRuleBean == null || policyRuleBean.getPolicyType() == null || policyRuleBean.getRuleType() == null || !this.addTimeIntervals(adder, dateRange, timeRange, policyRuleBean.getPolicyType(), policyRuleBean.getRuleType())) {
                this.logger.error("Unable to add the extra parameters: an error occourred in the update process");
                this.reloadPolicies();
                return new ResponseBean(-1, ruleID);
            }
        }
        this.logger.debug("Rule completed");
        this.reloadPolicies();
        return new ResponseBean(0, ruleID);
    }

    private void reloadPolicies() {
        if (!this.reloader.reloadPolicies()) {
            this.logger.warn("Unable to reload policies!!");
        }
    }
}

