/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.javaapi.impl.engine;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PolicyReloader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String policyLoaderUrl;
    private final String PATH = "/reloadPolicy";

    public PolicyReloader(String policyLoaderUrl) {
        this.policyLoaderUrl = policyLoaderUrl;
        if (this.policyLoaderUrl == null) {
            this.logger.warn("No real time policy reloading");
        }
    }

    public boolean reloadPolicies() {
        if (this.policyLoaderUrl != null) {
            try {
                this.logger.debug("Reloading policies");
                DefaultClientConfig config = new DefaultClientConfig();
                Client client = Client.create((ClientConfig)config);
                WebResource service = client.resource(this.policyLoaderUrl);
                this.logger.debug("refreshing policies explicitly.. ");
                ClientResponse response = (ClientResponse)service.path("/reloadPolicy").get(ClientResponse.class);
                ClientResponse.Status status = response.getClientResponseStatus();
                this.logger.debug("Response = " + status);
                return status.getStatusCode() >= 200 && status.getStatusCode() <= 300;
            }
            catch (RuntimeException e) {
                this.logger.debug("No policy reloaded", (Throwable)e);
                return false;
            }
        }
        this.logger.debug("No policy reload");
        return true;
    }
}

