/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.impl;

import it.eng.rdlab.soa3.connector.utils.XMLUtils;
import it.eng.rdlab.soa3.pm.connector.beans.Status;
import it.eng.rdlab.soa3.pm.connector.impl.PolicyGetUtils;
import it.eng.rdlab.soa3.pm.connector.interfaces.PolicyReader;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PolicyReaderImpl
implements PolicyReader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String url;

    public PolicyReaderImpl() {
    }

    public PolicyReaderImpl(String url) {
        this();
        this.setUrl(url);
    }

    public void setUrl(String url) {
        this.url = url + "/";
    }

    @Override
    public Status listPolicies(String alias) {
        return this.getElement(alias, null, "listPolicies", null, "listPoliciesResponse");
    }

    @Override
    public Status getPolicy(String alias, String policyId) {
        return this.getElement(alias, policyId, "getPolicy", "policyId", "getPolicyResponse");
    }

    @Override
    public Status listPolicySets(String alias) {
        return this.getElement(alias, null, "listPolicySets", null, "listPolicySetsResponse");
    }

    @Override
    public Status getPolicySet(String alias, String policySetId) {
        return this.getElement(alias, policySetId, "getPolicySet", "policySetId", "getPolicySetReturn");
    }

    private Status getElement(String alias, String elementId, String tagRequest, String tagElementID, String tagReturnElement) {
        SOAPMessage soapResponse = null;
        try {
            String url = this.url + "XACMLPolicyManagementService";
            this.logger.debug("Url = " + url);
            soapResponse = PolicyGetUtils.identifyElement(url, alias, elementId, tagRequest, tagElementID);
            if (soapResponse == null) {
                this.logger.error("Server error");
                return new Status(1, 1);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to generate soap message", (Throwable)e);
            return new Status(2, 1);
        }
        try {
            String xacmlResponse = this.parseResponse(soapResponse, tagReturnElement);
            if (xacmlResponse != null) {
                Status responseStatus = new Status(0, 0);
                responseStatus.setInfo(xacmlResponse);
                return responseStatus;
            }
            this.logger.debug("Response false");
            return new Status(0, 1);
        }
        catch (Exception e) {
            this.logger.error("Invalid response received", (Throwable)e);
            return new Status(1, 1);
        }
    }

    private String parseResponse(SOAPMessage response, String tagResponse) throws Exception {
        this.logger.debug("Parsing response message...");
        SOAPBody responseBody = response.getSOAPBody();
        NodeList nodeList = responseBody.getElementsByTagName(tagResponse);
        if (nodeList.getLength() > 0) {
            NodeList policies = nodeList.item(0).getChildNodes();
            String info = null;
            if (policies.getLength() > 0) {
                info = XMLUtils.element2String((Element)((Element)policies.item(0)));
            }
            return info;
        }
        return null;
    }
}

