/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.authn.rest.impl;

import it.eng.rdlab.soa3.authn.rest.AuthenticationContext;
import it.eng.rdlab.soa3.authn.rest.IAuthenticationService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.simple.SimpleLdapTemplate;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

public class AuthenticationServiceImpl
implements IAuthenticationService {
    static Logger logger = Logger.getLogger((String)AuthenticationServiceImpl.class.getName());
    private SimpleLdapTemplate ldapTemplate;
    private AuthenticationContext authenticationContext;

    public AuthenticationServiceImpl() {
        this.configureLdap();
    }

    public boolean authenticate(String userName, String password) {
        logger.debug((Object)"Ldap configuration completed successfully..");
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter("uid", userName));
        logger.debug((Object)("contacting ldap with filter " + filter));
        return this.ldapTemplate.authenticate("", filter.toString(), password);
    }

    private void configureLdap() {
        FileSystemResource resource = new FileSystemResource(System.getProperty("catalina.home") + "/conf/soa3/ldap.xml");
        if (!resource.exists()) {
            logger.debug((Object)"loading default ldap config from filesystem");
            resource = new ClassPathResource("it/rdlab/config/ldap.xml");
        }
        logger.debug((Object)("Using the config from file " + resource.getFilename()));
        XmlBeanFactory factory = new XmlBeanFactory((Resource)resource);
        AuthenticationContext authenticationContext = (AuthenticationContext)factory.getBean("authenticationContext");
        this.ldapTemplate = authenticationContext.getLdapTemplate();
        logger.debug((Object)" configured context source and ldap template..");
        this.authenticationContext = authenticationContext;
    }

    public boolean isUserAuthenticated(String userName, String password) {
        return this.authenticate(userName, password);
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }
}

