/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.authn.rest.jaxrs;

import com.sun.jersey.api.core.HttpContext;
import it.eng.rdlab.soa3.authn.rest.bean.AuthenticateResponseBean;
import it.eng.rdlab.soa3.authn.rest.exceptions.JSONParserException;
import it.eng.rdlab.soa3.authn.rest.impl.AuthenticationServiceImpl;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

@Path(value="/authenticate")
public class AuthenticationService {
    private static final Log logger = LogFactory.getLog(AuthenticationService.class);

    public AuthenticationService() {
        logger.debug((Object)"logger instantiator called");
    }

    @GET
    @Produces(value={"application/json"})
    public String isUserAuthenticated(@Context HttpContext context) {
        String authHeader = context.getRequest().getHeaderValue("Authorization");
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        mapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        AuthenticationServiceImpl authService = new AuthenticationServiceImpl();
        if (authHeader != null) {
            if (!authHeader.contains(" ")) {
                logger.error((Object)"check the if the \"Authorization\" header has a value of the format : Basic Base64encoded{username:password}");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" Missing or invalid request contents ").build());
            }
            String encodedValue = authHeader.split(" ")[1];
            String decodedValue = new String(Base64.decodeBase64((byte[])encodedValue.getBytes()));
            if (!decodedValue.contains(":")) {
                logger.error((Object)"check the if the \"Authorization\" header has a value of the format : Basic Base64encoded{username:password}");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" Missing or invalid request contents ").build());
            }
            String userName = decodedValue.split(":")[0];
            String password = null;
            try {
                password = decodedValue.split(":")[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                logger.error((Object)"Password field is empty, please provide a password");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" Password field is empty, please provide a password ").build());
            }
            logger.error((Object)("user to be authenticated is " + userName));
            boolean isAuthenticated = false;
            try {
                isAuthenticated = authService.isUserAuthenticated(userName, password);
                logger.debug((Object)"Adding ldap information...");
                logger.debug((Object)"Ldap information added");
            }
            catch (Exception e) {
                logger.error((Object)" user does not exist ");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("user " + userName + "  does not exist")).build());
            }
            if (!isAuthenticated) {
                logger.error((Object)("authentication unsuccessful for user " + userName));
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Wrong credentials, check username and password ").build());
            }
            try {
                logger.debug((Object)("authentication successful for user " + userName));
                String value = mapper.writeValueAsString((Object)new AuthenticateResponseBean(userName));
                return value;
            }
            catch (JsonGenerationException e) {
                logger.error((Object)"get data unsuccessful due to json parse error  ");
                throw new JSONParserException("Unable to generate JSON ", (Throwable)e);
            }
            catch (JsonMappingException e) {
                logger.error((Object)"get data unsuccessful due to json parse error  ");
                throw new JSONParserException("Unable to map JSON ", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"get data unsuccessful due to json parse error  ");
                throw new JSONParserException("IO Exception while parsing JSON ", (Throwable)e);
            }
        }
        logger.error((Object)"authentication unsuccessful for user as the authorization header is null  ");
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" Missing or invalid request contents ").build());
    }
}

