/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.authn.rest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LoggerInstantiator {
    static Logger logger = Logger.getLogger((String)LoggerInstantiator.class.getName());
    private static final String catalina_home = "catalina.home";
    private static Properties prop = new Properties();

    public static LoggerInstantiator getInstance() {
        return new LoggerInstantiator();
    }

    protected LoggerInstantiator() {
        if (!prop.isEmpty()) {
            return;
        }
        try {
            InputStream in;
            if (System.getProperty(catalina_home) != null) {
                logger.info((Object)("CATALINA.HOME system property defined. Will look in $CATALINA_HOME/conf for the log configuration file - logger_ips.properties ! " + System.getProperty(catalina_home)));
                File logFile = new File(System.getProperty(catalina_home) + "/conf/ipsConfig/logger_ips.properties");
                in = !logFile.exists() ? this.getClass().getResourceAsStream("logger_ips.properties") : new FileInputStream(logFile);
            } else {
                in = this.getClass().getResourceAsStream("logger_ips.properties");
            }
            prop.load(in);
            PropertyConfigurator.configure((Properties)prop);
            logger.info((Object)"Logger initialized. ");
        }
        catch (NullPointerException ex) {
            System.out.println("Fatal Error at LoggerInstantiator: " + ex);
            System.exit(-1);
        }
        catch (IOException ex) {
            System.out.println("Fatal Error at LoggerInstantiator: " + ex);
            System.exit(-1);
        }
    }
}

