package it.eng.rdlab.soa3.authn.rest.jaxrs;


import it.eng.rdlab.soa3.authn.rest.IAuthenticationService;
import it.eng.rdlab.soa3.authn.rest.bean.AuthenticateResponseBean;
import it.eng.rdlab.soa3.authn.rest.exceptions.JSONParserException;
import it.eng.rdlab.soa3.authn.rest.impl.AuthenticationServiceImpl;
import it.eng.rdlab.soa3.authn.rest.util.Constants;

import java.io.IOException;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

import com.sun.jersey.api.core.HttpContext;

/**
 * 
 * @author Kanchanna Ramasamy Balraj
 * @author Ermanno Travaglino
 * 
 */

@Path("/authenticate")
public class AuthenticationService {


	private static final Log logger = LogFactory
			.getLog(AuthenticationService.class);

	public AuthenticationService(){
		logger.debug("logger instantiator called");
	}

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	public String isUserAuthenticated(@Context HttpContext context) 
	{

		String authHeader = context.getRequest().getHeaderValue("Authorization");
		ObjectMapper mapper = new ObjectMapper();
		AnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
		mapper.getDeserializationConfig().setAnnotationIntrospector(introspector);
		mapper.getSerializationConfig().setAnnotationIntrospector(introspector);
		IAuthenticationService authService = new AuthenticationServiceImpl();

		if (authHeader != null) 
		{
			if(!authHeader.contains(" "))
			{
				logger.error("check the if the \"Authorization\" header has a value of the format : Basic Base64encoded{username:password}");
				throw new WebApplicationException(Response.status(Status.BAD_REQUEST).entity(" Missing or invalid request contents ").build());
			}
			String encodedValue = authHeader.split(" ")[1];
			String decodedValue = new String(Base64.decodeBase64(encodedValue.getBytes()));

			if(!decodedValue.contains(Constants.PASSWORD_SEPARATOR))
			{
				logger.error("check the if the \"Authorization\" header has a value of the format : Basic Base64encoded{username:password}");
				throw new WebApplicationException(Response.status(Status.BAD_REQUEST).entity(" Missing or invalid request contents ").build());
			}

			String userName = decodedValue.split(Constants.PASSWORD_SEPARATOR)[0];
			String password = null;

			try
			{
				password = decodedValue.split(Constants.PASSWORD_SEPARATOR)[1];
			}
			catch(ArrayIndexOutOfBoundsException e)
			{
				logger.error("Password field is empty, please provide a password");
				throw new WebApplicationException(Response.status(Status.BAD_REQUEST).entity(" Password field is empty, please provide a password ")
						.build());
			}


			logger.error("user to be authenticated is " + userName);
			boolean isAuthenticated = false;

			try 
			{

				isAuthenticated = authService.isUserAuthenticated(userName, password);
				logger.debug("Adding ldap information...");
				logger.debug("Ldap information added");
			} 
			catch (Exception e) 
			{
				logger.error(" user does not exist ");
				throw new WebApplicationException(Response
						.status(Status.BAD_REQUEST)
						.entity("user "+ userName+"  does not exist")
						.build());
			}

			if (!isAuthenticated) 
			{
				logger.error("authentication unsuccessful for user " + userName);
				throw new WebApplicationException(
						Response.status(Status.UNAUTHORIZED)
						.entity("Wrong credentials, check username and password ")
						.build());
			} else {
				try {
					logger.debug("authentication successful for user "
							+ userName);
					String value = mapper
							.writeValueAsString(new AuthenticateResponseBean(
									userName));
					return value;
				} catch (JsonGenerationException e) 
				{
					logger.error("get data unsuccessful due to json parse error  ");
					throw new JSONParserException(
							"Unable to generate JSON ", e);
				} catch (JsonMappingException e) {
					logger.error("get data unsuccessful due to json parse error  ");
					throw new JSONParserException("Unable to map JSON ", e);
				} catch (IOException e) {
					logger.error("get data unsuccessful due to json parse error  ");
					throw new JSONParserException(
							"IO Exception while parsing JSON ", e);
				}

			}

		} 
		else 
		{
			logger.error("authentication unsuccessful for user as the authorization header is null  ");
			throw new WebApplicationException(Response
					.status(Status.BAD_REQUEST)
					.entity(" Missing or invalid request contents ").build());

		}

	}

//	@GET
//	@Path("/input/{input}")
//	private String getBase64encode(@PathParam("input")String username){
//		logger.debug("base64 encoder called");
//		return new String(Base64.encodeBase64(username.getBytes()));
//	}
//
//
//	public static void main(String[] args) {
//		System.out.println(new AuthenticationService().getBase64encode("test:test"));
//	}

}
