/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.conf;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationManager {
    private Properties properties;
    private Log log = LogFactory.getLog(this.getClass());
    private static ConfigurationManager instance;
    private final String CONFIGURATION_ROOT = "CONFIGURATION_ROOT";
    private final String CONFIGURATION_FILE = "CONFIGURATION_FILE";
    private final String LDAP_URL = "LDAP_URL";
    private final String LDAP_BASE = "LDAP_BASE";
    private final String LDAP_DN = "LDAP_USER_DN";
    private final String LDAP_PWD = "LDAP_PASSWORD";
    private final String LDAP_DUMMY_ROOT = "LDAP_DUMMY_ROOT";
    private final String DEFAULT_PROP_FILE = "/it/eng/rdlab/soa3/um/rest/conf/configuration.properties";
    private final String PROP_FILES = "/it/eng/rdlab/soa3/um/rest/conf/configurationfiles.properties";

    private ConfigurationManager() {
        Properties files = this.getConfigurationFiles();
        String root = files.getProperty("CONFIGURATION_ROOT", "");
        String path = files.getProperty("CONFIGURATION_FILE", "");
        if (root != null && root.startsWith("$")) {
            root = System.getProperty(root.substring(1));
            this.log.debug((Object)("Actual root " + root));
        }
        path = root + path;
        this.log.debug((Object)("Configuration path = " + path));
        this.properties = new Properties();
        try {
            this.properties.load(new FileInputStream(path));
        }
        catch (Exception e) {
            this.log.warn((Object)"Configuration file not found", (Throwable)e);
            this.log.warn((Object)"Using default values");
            try {
                this.properties.load(this.getClass().getResourceAsStream("/it/eng/rdlab/soa3/um/rest/conf/configuration.properties"));
            }
            catch (IOException e1) {
                this.log.error((Object)"Unable to find properties from the classpath", (Throwable)e);
            }
        }
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    private Properties getConfigurationFiles() {
        Properties fileProperties = new Properties();
        try {
            fileProperties.load(this.getClass().getResourceAsStream("/it/eng/rdlab/soa3/um/rest/conf/configurationfiles.properties"));
        }
        catch (IOException e1) {
            this.log.error((Object)"Unable to find properties from the classpath", (Throwable)e1);
        }
        return fileProperties;
    }

    public String getLdapUrl() {
        return this.properties.getProperty("LDAP_URL");
    }

    public String getLdapBase() {
        return this.properties.getProperty("LDAP_BASE");
    }

    public String getLdapUserDN() {
        return this.properties.getProperty("LDAP_USER_DN");
    }

    public String getLdapPwd() {
        return this.properties.getProperty("LDAP_PASSWORD");
    }

    public String getLdapDummyRoot() {
        return this.properties.getProperty("LDAP_DUMMY_ROOT");
    }
}

