/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.impl;

import it.eng.rdlab.soa3.um.rest.IUserManagementService;
import it.eng.rdlab.soa3.um.rest.conf.ConfigurationManager;
import it.eng.rdlab.soa3.um.rest.utils.Utils;
import it.eng.rdlab.um.exceptions.RoleRetrievalException;
import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.exceptions.UserRetrievalException;
import it.eng.rdlab.um.ldap.crossoperations.LdapUserRoleOperations;
import it.eng.rdlab.um.ldap.role.bean.LdapRoleModel;
import it.eng.rdlab.um.ldap.role.service.LdapRoleManager;
import it.eng.rdlab.um.ldap.user.bean.LdapUserModel;
import it.eng.rdlab.um.ldap.user.service.LdapUserManager;
import it.eng.rdlab.um.role.beans.RoleModel;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class RoleManagerImpl
implements IUserManagementService.RoleManager {
    static Logger logger = Logger.getLogger((String)RoleManagerImpl.class.getName());
    private String ldapUrl = null;
    private String[] system_roles = new String[]{"TENANT_ADMIN", "END_USER"};

    public RoleManagerImpl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public String createRole(String roleName, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Creating role: " + roleName));
        LdapRoleManager manager = null;
        String response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            LdapRoleModel roleModel = new LdapRoleModel();
            String dn = Utils.roleDNBuilder((String)roleName, (String)organizationName);
            roleModel.setRoleId(dn);
            roleModel.setRoleName(roleName);
            roleModel.addRoleOccupantDN("");
            response = manager.createRole((RoleModel)roleModel) ? dn : null;
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean updateRolesOfOrganization(List<String> roleNames, String organizationName, String adminUserId, String password) {
        LdapRoleManager manager = null;
        String response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String finalRoleName;
            List roles = manager.listRoles();
            ArrayList<String> groupNames = new ArrayList<String>();
            for (RoleModel roleModel2 : roles) {
                boolean isDeleted;
                finalRoleName = roleModel2.getRoleName();
                if (roleNames.contains(finalRoleName)) {
                    groupNames.add(finalRoleName);
                    continue;
                }
                if (finalRoleName.equals("TENANT_ADMIN") || (isDeleted = this.deleteRole(finalRoleName, organizationName, adminUserId, password))) continue;
                logger.error((Object)("An old role: " + finalRoleName + " is not deleted for organization " + organizationName));
            }
            LdapRoleModel ldapRoleModel = new LdapRoleModel();
            for (String roleName : roleNames) {
                String dn = Utils.roleDNBuilder((String)roleName, (String)organizationName);
                ldapRoleModel.setRoleId(dn);
                ldapRoleModel.setRoleName(roleName);
                if (!groupNames.contains(roleName)) {
                    logger.debug((Object)("Rolename does not exist already, hence creating one: " + roleName));
                    finalRoleName = manager.createRole((RoleModel)ldapRoleModel) ? dn : null;
                    if (finalRoleName != null) continue;
                    logger.debug((Object)"An error occourred during the operation");
                    return false;
                }
                logger.debug((Object)("Role already present, so leaving it as it is: " + roleName));
            }
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
            return false;
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return true;
    }

    public boolean deleteRole(String roleName, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Deleting role: " + roleName));
        LdapRoleManager manager = null;
        boolean response = false;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String dn = Utils.roleDNBuilder((String)roleName, (String)organizationName);
            response = manager.deleteRole(dn);
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public String getRoleIdByName(String roleName, String organizationName) {
        return Utils.roleDNBuilder((String)roleName, (String)organizationName);
    }

    public List<it.eng.rdlab.soa3.um.rest.bean.RoleModel> listRoles(String adminUserId, String password) {
        return this.listRolesByOrganization("", adminUserId, password);
    }

    public List<it.eng.rdlab.soa3.um.rest.bean.RoleModel> listRolesByOrganization(String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Listing all roles for organization " + organizationName));
        LdapRoleManager manager = null;
        ArrayList<it.eng.rdlab.soa3.um.rest.bean.RoleModel> response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            response = new ArrayList<it.eng.rdlab.soa3.um.rest.bean.RoleModel>();
            List modelList = manager.listRoles();
            for (RoleModel currentRole : modelList) {
                String roleDn = currentRole.getRoleId();
                logger.debug((Object)("Generating role model for role " + roleDn));
                it.eng.rdlab.soa3.um.rest.bean.RoleModel role = new it.eng.rdlab.soa3.um.rest.bean.RoleModel();
                logger.debug((Object)("Role Id = " + roleDn));
                role.setRoleId(roleDn);
                role.setRoleName(currentRole.getRoleName());
                role.setDescription(currentRole.getDescription());
                logger.debug((Object)"Model generated");
                response.add(role);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public List<it.eng.rdlab.soa3.um.rest.bean.RoleModel> listRolesByUser(String userId, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Getting all user roles for " + userId + " from: " + organizationName));
        LdapUserManager manager = null;
        ArrayList<it.eng.rdlab.soa3.um.rest.bean.RoleModel> roleList = new ArrayList<it.eng.rdlab.soa3.um.rest.bean.RoleModel>();
        List ldapRole = new ArrayList();
        try {
            String organizationDn = Utils.organizationDNBuilder((String)organizationName);
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserManager(organizationDn);
            LdapUserModel user = (LdapUserModel)manager.getUser(Utils.userDNBuilder((String)userId, (String)organizationName));
            LdapUserRoleOperations userRoleManager = new LdapUserRoleOperations(manager, new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName)));
            ldapRole = userRoleManager.listRolesByUser(user.getFullname());
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
        }
        catch (UserManagementSystemException e) {
            logger.debug((Object)"System error ");
        }
        catch (UserRetrievalException e) {
            logger.debug((Object)"No users found");
        }
        catch (RoleRetrievalException e) {
            e.printStackTrace();
        }
        for (RoleModel gm : ldapRole) {
            it.eng.rdlab.soa3.um.rest.bean.RoleModel role = new it.eng.rdlab.soa3.um.rest.bean.RoleModel();
            role.setRoleId(gm.getRoleId());
            role.setRoleName(gm.getRoleName());
            role.setDescription(gm.getDescription());
            logger.debug((Object)"Role model created");
            roleList.add(role);
        }
        return roleList;
    }

    public boolean updateRole(it.eng.rdlab.soa3.um.rest.bean.RoleModel role, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Updating role: " + role.getRoleName()));
        LdapRoleManager manager = null;
        boolean response = false;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            LdapRoleModel group = new LdapRoleModel();
            group.setDN(role.getRoleId());
            group.setRoleName(role.getRoleName());
            group.setDescription(role.getDescription());
            response = manager.updateRole((RoleModel)group);
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean deleteRoles(String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Removing all roles for organization " + organizationName));
        LdapRoleManager manager = null;
        boolean response = true;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            List modelList = manager.listRoles();
            for (RoleModel role : modelList) {
                String roleDn = role.getRoleId();
                logger.debug((Object)("Deleting role model for group " + roleDn));
                boolean partialResponse = manager.deleteRole(roleDn);
                logger.debug((Object)("Operation result " + partialResponse));
                response &= partialResponse;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean removeAllUsers(String roleName, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Removing all users from the role " + roleName));
        LdapRoleManager manager = null;
        boolean response = false;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            LdapRoleModel group = (LdapRoleModel)manager.getRole(Utils.roleDNBuilder((String)roleName, (String)organizationName));
            group.getRoleOccupantDNS().clear();
            group.addRoleOccupantDN(ConfigurationManager.getInstance().getLdapBase());
            logger.debug((Object)"Updating LDAP");
            response = manager.updateRole((RoleModel)group);
            logger.debug((Object)"Update completed");
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public it.eng.rdlab.soa3.um.rest.bean.RoleModel getRole(String roleName, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Getting the role " + roleName));
        LdapRoleManager manager = null;
        it.eng.rdlab.soa3.um.rest.bean.RoleModel response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            LdapRoleModel ldapRoleModel = (LdapRoleModel)manager.getRole(Utils.roleDNBuilder((String)roleName, (String)organizationName));
            String roleDn = ldapRoleModel.getRoleId();
            logger.debug((Object)("Generating role model for group " + roleDn));
            it.eng.rdlab.soa3.um.rest.bean.RoleModel roleModel = new it.eng.rdlab.soa3.um.rest.bean.RoleModel();
            roleModel.setRoleId(roleDn);
            roleModel.setRoleName(ldapRoleModel.getRoleName());
            roleModel.setDescription(ldapRoleModel.getDescription());
            logger.debug((Object)"Model generated");
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response != null ? 1 : 0));
        return response;
    }

    public boolean deleteCustomRoles(String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Removing all roles for organization " + organizationName));
        LdapRoleManager manager = null;
        boolean response = true;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapRoleManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            List modelList = manager.listRoles();
            for (RoleModel role : modelList) {
                if (role.getRoleName().equals(this.system_roles[0]) || role.getRoleName().equals(this.system_roles[1])) continue;
                String roleDn = role.getRoleId();
                logger.debug((Object)("Deleting role model for role " + roleDn));
                boolean partialResponse = manager.deleteRole(roleDn);
                logger.debug((Object)("Operation result " + partialResponse));
                response &= partialResponse;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }
}

