/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSException;

public class CredentialsUtil {
    private static Logger logger = Logger.getLogger((String)CredentialsUtil.class.getName());

    public static String stringCredentials(ExtendedGSSCredential credentials) {
        if (credentials == null) {
            return "Null credentials!!!";
        }
        try {
            return "Credentials[DN='" + CredentialsUtil.getIdentityDN(credentials) + ", CA='" + CredentialsUtil.getIssuerDN(credentials) + "', lifetime " + credentials.getRemainingLifetime() / 3600 + " hours]";
        }
        catch (GSSException e) {
            logger.error((Object)"Not parsable credentials!!!", (Throwable)e);
            return "Not parsable credentials!!!";
        }
    }

    public static String getIssuerDN(ExtendedGSSCredential credentials) {
        if (credentials == null) {
            return "Null Credentials!!!";
        }
        if (credentials instanceof GlobusGSSCredentialImpl) {
            GlobusGSSCredentialImpl cred = (GlobusGSSCredentialImpl)credentials;
            return CertUtil.toGlobusID((String)cred.getGlobusCredential().getIssuer());
        }
        return null;
    }

    public static String getIdentityDN(ExtendedGSSCredential credentials) {
        if (credentials == null) {
            throw new NullPointerException("Credentials cannot be null");
        }
        if (credentials instanceof GlobusGSSCredentialImpl) {
            GlobusGSSCredentialImpl cred = (GlobusGSSCredentialImpl)credentials;
            return cred.getGlobusCredential().getIdentity();
        }
        return null;
    }

    public static boolean isExpired(ExtendedGSSCredential credentials) {
        if (credentials == null) {
            throw new NullPointerException("Credentials cannot be null");
        }
        try {
            return credentials.getRemainingLifetime() == 0;
        }
        catch (GSSException e) {
            logger.error((Object)("Cannot verify lifetime of " + CredentialsUtil.stringCredentials(credentials)), (Throwable)e);
            return true;
        }
    }

    public static ExtendedGSSCredential loadEndEntityCredentials(String certFile, String keyFile, String password) throws IOException, GeneralSecurityException, GSSException {
        BouncyCastleOpenSSLKey key = new BouncyCastleOpenSSLKey(keyFile);
        if (key.isEncrypted()) {
            key.decrypt(password);
        }
        PrivateKey userKey = key.getPrivateKey();
        X509Certificate[] userCerts = CertUtil.loadCertificates((String)certFile);
        GlobusCredential proxy = new GlobusCredential(userKey, userCerts);
        return new GlobusGSSCredentialImpl(proxy, 0);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

